% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country_info.R
\name{country_info}
\alias{country_info}
\title{Get information about countries}
\usage{
country_info(
  countries = NULL,
  fields = NULL,
  fuzzy_match = TRUE,
  match_info = FALSE,
  collapse = TRUE
)
}
\arguments{
\item{countries}{A vector of countries for which we wish to download information. The function also supports fuzzy matching capabilities to facilitate querying. Information is only returned for the 249 countries in the ISO standard \code{3166}.}

\item{fields}{Character vector indicating the fields to query. A description of the \href{https://gitlab.com/restcountries/restcountries/-/blob/master/FIELDS.md}{accepted fields can be found here}. Alternatively, a list of accepted field names can be obtained with the function \code{list_fields()}.}

\item{fuzzy_match}{Logical value indicating whether to allow fuzzy matching of country names. Default is \code{TRUE}.}

\item{match_info}{Logical value indicating whether to return information on country names matched to each input in \code{countries}. If \code{TRUE}, two additional columns will be added to the output (\code{matched_country} and \code{is_country}). Default is \code{FALSE}.}

\item{collapse}{Logical value indicating whether to collapse multiple columns relating to a same field together. Default is \code{TRUE}. For some specific fields (currencies, languages, names), multiple columns will be returned. This happens because countries can take multiple values for these fields. For example, \code{country_info("Switzerland", "languages", collapse = FALSE)} will return 4 columns for the field languages. When \code{collapse = TRUE}, these four columns will be collapsed into one string, with values separated by semicolons.}
}
\value{
Returns the requested information about the countries in a table. The rows of the table correspond to entries in \code{countries}, columns correspond to requested \code{fields}.
}
\description{
This function is an interface for \href{https://restcountries.com/}{REST Countries API}.
It allows to request and download information about countries, such as: currency, capital city, language spoken, flag, neighbouring countries, and much more.
\strong{NOTE:} Internet access is needed to download information from the API.
}
\examples{
# The example below queries information on the currency used in Brazil, US and France:
info <- country_info(countries = "Brazil", fields = "capital")

# data for multiple countries can be requested
info <- country_info(countries = c("Brazil", "USA", "FR"), fields = "capital")

#' # Data can be returned for all countries by leaving - countries - empty
info <- country_info(fields = "capital")

# All available fields can be requested by leaving fields empty
info <- country_info(countries = c("Brazil", "USA", "FR"))

# All information for all countries can be downloaded by leaving both arguments empty
info <- country_info()
}
\seealso{
\link[countries]{list_fields}
}
