% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mode.R
\name{Mode}
\alias{Mode}
\title{Statistical mode of a vector}
\usage{
Mode(x, na.rm = FALSE, first_only = FALSE)
}
\arguments{
\item{x}{A vector}

\item{na.rm}{Logical value indicating whether \code{NA} values should be omitted. Default is \code{FALSE}.}

\item{first_only}{Logical value indicating whether only the first mode should be returned if \code{x} has multiple modes (i.e. there are multiple values with the highest number of observations). Default is FALSE.}
}
\value{
Returns the mode of the vector \code{x}
}
\description{
This function returns the mode of vectors. That is to say, for any given vector of values, it returns the value that appears most frequently.
The function works with strings, numerical and mixed inputs. \code{NA} values are treated as distinct values.
}
\examples{
countries::Mode(c("a","a",2,3))
countries::Mode(c(1,1,2,3,NA,2))
countries::Mode(c(NA,NA,NA,1,1,2))
}
