% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_marker.R
\name{RankMarkerGenes}
\alias{RankMarkerGenes}
\title{Rank the top marker genes for each cluster from spectral clustering.}
\usage{
RankMarkerGenes(C, method = "prop-zero", subsample = FALSE)
}
\arguments{
\item{C}{countland object}

\item{method}{\code{prop-zero} to rank by proportion of cells that are non-zero (default), or \code{rank-sums} to rank using Wilcoxon rank-sums test}

\item{subsample}{if TRUE, use subsampled counts, otherwise use counts (default=FALSE)}
}
\value{
countland object with slots \code{marker_genes} and \code{marker_full}
}
\description{
Rank the top marker genes for each cluster from spectral clustering.
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
C <- Dot(C)
C <- Embed(C,n_components=5)
C <- Cluster(C,n_clusters=3)
C <- RankMarkerGenes(C,method='prop-zero',subsample=FALSE)
}
