% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CounterfactualMethodClassif.R
\name{CounterfactualMethodClassif}
\alias{CounterfactualMethodClassif}
\title{Base class for Counterfactual Explanation Methods for Classification Tasks}
\description{
Abstract base class for counterfactual explanation methods for classifcation tasks.

\code{CounterfactualMethodClassif} can only be initialized for classification tasks. Child classes inherit the (public)
\verb{$find_counterfactuals()} method, which calls a (private) \verb{$run()} method. This \verb{$run()} method should be implemented
by the child classes and return the counterfactuals as a \code{data.table} (preferably) or a \code{data.frame}.
}
\section{Inheritance}{

Child classes: \link{MOCClassif}, \link{WhatIfClassif}, \link{NICEClassif}
}

\concept{find_counterfactuals}
\section{Super class}{
\code{\link[counterfactuals:CounterfactualMethod]{counterfactuals::CounterfactualMethod}} -> \code{CounterfactualMethodClassif}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CounterfactualMethodClassif-new}{\code{CounterfactualMethodClassif$new()}}
\item \href{#method-CounterfactualMethodClassif-find_counterfactuals}{\code{CounterfactualMethodClassif$find_counterfactuals()}}
\item \href{#method-CounterfactualMethodClassif-clone}{\code{CounterfactualMethodClassif$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="counterfactuals" data-topic="CounterfactualMethod" data-id="print"><a href='../../counterfactuals/html/CounterfactualMethod.html#method-CounterfactualMethod-print'><code>counterfactuals::CounterfactualMethod$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CounterfactualMethodClassif-new"></a>}}
\if{latex}{\out{\hypertarget{method-CounterfactualMethodClassif-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{CounterfactualMethodClassif} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CounterfactualMethodClassif$new(
  predictor,
  lower = NULL,
  upper = NULL,
  distance_function = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictor}}{(\link[iml]{Predictor})\cr
The object (created with \code{iml::Predictor$new()}) holding the machine learning model and the data.}

\item{\code{lower}}{(\code{numeric()} | \code{NULL})\cr
Vector of minimum values for numeric features.
If \code{NULL} (default), the element for each numeric feature in \code{lower} is taken as its minimum value in \code{predictor$data$X}.
If not \code{NULL}, it should be named with the corresponding feature names.}

\item{\code{upper}}{(\code{numeric()} | \code{NULL})\cr
Vector of maximum values for numeric features.
If \code{NULL} (default), the element for each numeric feature in \code{upper} is taken as its maximum value in \code{predictor$data$X}.
If not \code{NULL}, it should be named with the corresponding feature names.}

\item{\code{distance_function}}{(\verb{function()} | \code{NULL})\cr
A distance function that may be used by the leaf classes.
If specified, the function must have three arguments: \code{x}, \code{y}, and \code{data} and return a \code{double} matrix with \code{nrow(x)}
rows and \code{nrow(y)} columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CounterfactualMethodClassif-find_counterfactuals"></a>}}
\if{latex}{\out{\hypertarget{method-CounterfactualMethodClassif-find_counterfactuals}{}}}
\subsection{Method \code{find_counterfactuals()}}{
Runs the counterfactual method and returns the counterfactuals.
It searches for counterfactuals that have a predicted probability in the interval \code{desired_prob} for the
\code{desired_class}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CounterfactualMethodClassif$find_counterfactuals(
  x_interest,
  desired_class = NULL,
  desired_prob = c(0.5, 1)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x_interest}}{(\code{data.table(1)} | \code{data.frame(1)}) \cr
A single row with the observation of interest.}

\item{\code{desired_class}}{(\code{character(1)} | \code{NULL}) \cr
The desired class. If \code{NULL} (default) then \code{predictor$class} is taken.}

\item{\code{desired_prob}}{(\code{numeric(1)} | \code{numeric(2)}) \cr
The desired predicted probability of the \code{desired_class}. It can be a numeric scalar or a vector with two
numeric values that specify a probability interval.
For hard classification tasks this can be set to \code{0} or \code{1}, respectively.
A scalar is internally converted to an interval.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{Counterfactuals} object containing the results.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CounterfactualMethodClassif-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CounterfactualMethodClassif-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CounterfactualMethodClassif$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
