% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STAR_Bayesian.R
\name{sample_lm_gprior}
\alias{sample_lm_gprior}
\title{Sample the linear regression parameters assuming a g-prior}
\usage{
sample_lm_gprior(y, X, params, psi = NULL, XtX = NULL, X_test = NULL)
}
\arguments{
\item{y}{\code{n x 1} vector of data}

\item{X}{\code{n x p} matrix of predictors}

\item{params}{the named list of parameters containing
\enumerate{
\item \code{mu}: vector of conditional means (fitted values)
\item \code{sigma}: the conditional standard deviation
\item \code{coefficients}: a named list of parameters that determine \code{mu}
}}

\item{psi}{the prior variance for the g-prior}

\item{XtX}{the \code{p x p} matrix of \code{crossprod(X)} (one-time cost);
if NULL, compute within the function}

\item{X_test}{matrix of predictors at test points (default is NULL)}
}
\value{
The updated named list \code{params} with draws from the full conditional distributions
of \code{sigma} and \code{coefficients} (along with updated \code{mu} and \code{mu_test} if applicable).
}
\description{
Sample the parameters for a linear regression model assuming a
g-prior for the  coefficients.
}
\note{
The parameters in \code{coefficients} are:
\itemize{
\item \code{beta}: the \code{p x 1} vector of regression coefficients
components of \code{beta}
}
}
\examples{
# Simulate data for illustration:
sim_dat = simulate_nb_lm(n = 100, p = 5)
y = sim_dat$y; X = sim_dat$X
# Initialize:
params = init_lm_gprior(y = y, X = X)
# Sample:
params = sample_lm_gprior(y = y, X = X, params = params)
names(params)
names(params$coefficients)

}
