% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STAR_frequentist.R
\name{lm_star}
\alias{lm_star}
\title{Fitting frequentist STAR linear model via EM algorithm}
\usage{
lm_star(
  formula,
  data = NULL,
  transformation = "np",
  y_max = Inf,
  sd_init = 10,
  tol = 10^-10,
  max_iters = 1000
)
}
\arguments{
\item{formula}{an object of class "\code{\link{formula}}" (see \code{\link{lm}} for details on model specification)}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame)
containing the variables in the model; like \code{\link{lm}}, if not found in data,
the variables are taken from \code{environment(formula)}}

\item{transformation}{transformation to use for the latent data; must be one of
\itemize{
\item "identity" (identity transformation)
\item "log" (log transformation)
\item "sqrt" (square root transformation)
\item "np" (nonparametric transformation estimated from empirical CDF)
\item "pois" (transformation for moment-matched marginal Poisson CDF)
\item "neg-bin" (transformation for moment-matched marginal Negative Binomial CDF)
\item "box-cox" (box-cox transformation with learned parameter)
}}

\item{y_max}{a fixed and known upper bound for all observations; default is \code{Inf}}

\item{sd_init}{add random noise for EM algorithm initialization scaled by \code{sd_init}
times the Gaussian MLE standard deviation; default is 10}

\item{tol}{tolerance for stopping the EM algorithm; default is 10^-10;}

\item{max_iters}{maximum number of EM iterations before stopping; default is 1000}
}
\value{
an object of \code{class} "lmstar", which is a list with the following elements:
\itemize{
\item \code{coefficients} the MLEs of the coefficients
\item \code{fitted.values} the fitted values at the MLEs
\item \code{g.hat} a function containing the (known or estimated) transformation
\item \code{ginv.hat} a function containing the inverse of the transformation
\item \code{sigma.hat} the MLE of the standard deviation
\item \code{mu.hat} the MLE of the conditional mean (on the transformed scale)
\item \code{z.hat} the estimated latent data (on the transformed scale) at the MLEs
\item \code{residuals} the Dunn-Smyth residuals (randomized)
\item \code{residuals_rep} the Dunn-Smyth residuals (randomized) for 10 replicates
\item \code{logLik} the log-likelihood at the MLEs
\item \code{logLik0} the log-likelihood at the MLEs for the *unrounded* initialization
\item \code{lambda} the Box-Cox nonlinear parameter
\item and other parameters that
(1) track the parameters across EM iterations and
(2) record the model specifications
}
}
\description{
Compute the MLEs and log-likelihood for the STAR linear model.
The regression coefficients are estimated using least squares within
an EM algorithm.
}
\details{
Standard function calls including
\code{\link{coefficients}}, \code{\link{fitted}}, and \code{\link{residuals}} apply. Fitted values are the expectation
at the MLEs, and as such are not necessarily count-valued.
}
\note{
Infinite latent data values may occur when the transformed
Gaussian model is highly inadequate. In that case, the function returns
the *indices* of the data points with infinite latent values, which are
significant outliers under the model. Deletion of these indices and
re-running the model is one option, but care must be taken to ensure
that (i) it is appropriate to treat these observations as outliers and
(ii) the model is adequate for the remaining data points.
}
\examples{
# Simulate data with count-valued response y:
sim_dat = simulate_nb_lm(n = 100, p = 3)
y = sim_dat$y; X = sim_dat$X

# Fit model
fit_em = lm_star(y~X)

# Fitted coefficients:
coef(fit_em)
# Fitted values:
y_hat = fitted(fit_em)
plot(y_hat, y);

# Residuals:
plot(residuals(fit_em))
qqnorm(residuals(fit_em)); qqline(residuals(fit_em))
}
\references{
Kowal, D. R., & Wu, B. (2021).
Semiparametric count data regression for self‐reported mental health.
\emph{Biometrics}. \doi{10.1111/biom.13617}
}
