% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{init_lm_hs}
\alias{init_lm_hs}
\title{Initialize linear regression parameters assuming a horseshoe prior}
\usage{
init_lm_hs(y, X, X_test = NULL)
}
\arguments{
\item{y}{\code{n x 1} vector of data}

\item{X}{\code{n x p} matrix of predictors}

\item{X_test}{\code{n0 x p} matrix of predictors at test points (default is NULL)}
}
\value{
a named list \code{params} containing at least
\enumerate{
\item \code{mu}: vector of conditional means (fitted values)
\item \code{sigma}: the conditional standard deviation
\item \code{coefficients}: a named list of parameters that determine \code{mu}
}
Additionally, if X_test is not NULL, then the list includes an element
\code{mu_test}, the vector of conditional means at the test points
}
\description{
Initialize the parameters for a linear regression model assuming a
horseshoe prior for the (non-intercept) coefficients. The number of predictors
\code{p} may exceed the number of observations \code{n}.
}
\note{
The parameters in \code{coefficients} are:
\itemize{
\item \code{beta}: the \code{p x 1} vector of regression coefficients
\item \code{sigma_beta}: the \code{p x 1} vector of regression coefficient standard deviations
(local scale parameters)
\item \code{xi_sigma_beta}: the \code{p x 1} vector of parameter-expansion variables for \code{sigma_beta}
\item \code{lambda_beta}: the global scale parameter
\item \code{xi_lambda_beta}: the parameter-expansion variable for \code{lambda_beta}
components of \code{beta}
}
}
\keyword{internal}
