% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/ConvexCombCopula.R, R/Cort.R,
%   R/CortForest.R, R/cbCopula.R, R/cbkmCopula.R
\name{rCopula}
\alias{rCopula}
\alias{rCopula,numeric,ConvexCombCopula-method}
\alias{rCopula,numeric,Cort-method}
\alias{rCopula,numeric,CortForest-method}
\alias{rCopula,numeric,cbCopula-method}
\alias{rCopula,numeric,cbkmCopula-method}
\title{Copula random generation}
\usage{
rCopula(n, copula, ...)

\S4method{rCopula}{numeric,ConvexCombCopula}(n, copula)

\S4method{rCopula}{numeric,Cort}(n, copula)

\S4method{rCopula}{numeric,CortForest}(n, copula)

\S4method{rCopula}{numeric,cbCopula}(n, copula)

\S4method{rCopula}{numeric,cbkmCopula}(n, copula)
}
\arguments{
\item{n}{the number of simulations}

\item{copula}{the copula object}

\item{...}{other parameter to be passed to methods for this generic.}
}
\value{
A matrix with \code{n} rows, each representing a random vector generated from the provided copula.
}
\description{
Random number generation following the given copula. This function performs the simulation of random vectors following the copula.
}
\section{Functions}{
\itemize{
\item \code{rCopula,numeric,ConvexCombCopula-method}: Method for the cbCopula

\item \code{rCopula,numeric,Cort-method}: Method for the class Cort

\item \code{rCopula,numeric,CortForest-method}: Method for the class CortForest

\item \code{rCopula,numeric,cbCopula-method}: Method for the cbCopula

\item \code{rCopula,numeric,cbkmCopula-method}: Method for the cbCopula
}}

\examples{
cop <- cbCopula(cort::clayton_data,m = 5)
xx <- rCopula(1000,cop)

}
