% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cort.R
\name{Cort-Class}
\alias{Cort-Class}
\alias{Cort}
\title{Cort copulas}
\usage{
Cort(
  x,
  p_value_for_dim_red = 0.75,
  min_node_size = 1,
  pseudo_data = FALSE,
  number_max_dim = NULL,
  verbose_lvl = 1,
  slsqp_options = NULL,
  osqp_options = NULL,
  N = 999,
  force_grid = FALSE
)
}
\arguments{
\item{x}{The data, must be provided as a matrix with each row as an observation.}

\item{p_value_for_dim_red}{a p_value for the localized dimension reduction test}

\item{min_node_size}{The minimum number of observation available in a leaf to initialize a split.}

\item{pseudo_data}{set to True if you are already providing data on the copula space.}

\item{number_max_dim}{The maximum number of dimension a split occurs in. Defaults to be all of the dimensions.}

\item{verbose_lvl}{numeric. set the verbosity. 0 for no output and bigger you set it the most output you get.}

\item{slsqp_options}{options for nloptr::slsqp to find breakpoints : you can change defaults.}

\item{osqp_options}{options for the weights optimization. You can pass a call to osqp::osqpSettings, or NULL for defaults.}

\item{N}{The number of bootstrap samples for p_values computations.}

\item{force_grid}{Set to TRUE to force breakpoints to be on the n-checkerboard grid.}
}
\value{
An instance of the \code{Cort} S4 class. The object represent the fitted copula and can be used through several methods to query classical (r/d/p/v)Copula methods, constraint influence, etc.
Beside returning some inputted parameters, notable slots are :

\itemize{
\item{\code{data} }{Your original data}
\item{\code{dim} }{The dimension of problem, number of columns of your dataset}
\item{\code{f} }{The empirical frequency in the leaves}
\item{\code{p} }{The fitted probabilities of each leaf}
\item{\code{a} }{Minimum points of leaves}
\item{\code{b} }{Maximum points of leaves}
\item{\code{vols} }{Volume of the leaves}
}

More details about these slots can be found in the reference.
}
\description{
Cort class
}
\details{
This class implements the CORT algorithm to a fit a multivariate copula using piece constant density. Given a dataset \code{x}, the function will produce an estimator for the copula of this dataset
that is tree-shaped, by recursive partitioning of the unit hypercube. the \code{min_node_size} parameter controls the stopping conditions for the splitting procedure. Once the space is splitted,
we ran a quadratic solver, which options can be tweaked via the \code{osqp_options} parameter, to ensure that the weights respect the copula conditions.

Once the model is fitted, it can be used through the classical (r/d/p/v)Copula functions to compute, respectively, random number generations, the density, the cdf and the volume function of the copula.

See O. Laverny, E. Masiello, V. Maume-Deschamps and D. Rullière (2020) for the details of this density estimation procedure, and \code{vignettes(package='cort')} for examples of usecases.
}
\examples{
(Cort(LifeCycleSavings[,1:3]))
}
\references{
\insertRef{laverny2020}{cort}
}
