% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate.R
\name{correlate}
\alias{correlate}
\title{Correlation Data Frame}
\usage{
correlate(x, y = NULL, use = "pairwise.complete.obs", method = "pearson")
}
\arguments{
\item{x}{a numeric vector, matrix or data frame.}

\item{y}{\code{NULL} (default) or a vector, matrix or data frame with
    compatible dimensions to \code{x}.   The default is equivalent to
    \code{y = x} (but more efficient).}

\item{use}{an optional character string giving a
    method for computing covariances in the presence
    of missing values.  This must be (an abbreviation of) one of the strings
    \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
    \code{"na.or.complete"}, or \code{"pairwise.complete.obs"}.}

\item{method}{a character string indicating which correlation
    coefficient (or covariance) is to be computed.  One of
    \code{"pearson"} (default), \code{"kendall"}, or \code{"spearman"}:
    can be abbreviated.}
}
\value{
A correlation data frame (cor_df)
}
\description{
An implementation of stats::cor(), which returns a correlation matrix in a
specific format. See details below. Additional adjustment include the use of
pairwise deletion by default.
}
\details{
\itemize{
  This function returns a correlation matrix in the following format:
  \item A tbl (tibble::data_frame)
  \item An additional class, "cor_df"
  \item A "rowname" column
  \item Standardised variances (the matrix diagonal) set to missing values
  (\code{NA}) so they can be ignored in calculations.
}

The main feature is the use of the data frame. This is to make use of data
frame manipulation packages like dplyr and tidyr.
}
\examples{
\dontrun{
correlate(iris)
}

correlate(mtcars)
correlate(iris[-5])
}

