% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{print.cornet}
\alias{print.cornet}
\title{Combined regression}
\usage{
\method{print}{cornet}(x, ...)
}
\arguments{
\item{x}{\link[cornet]{cornet} object}

\item{...}{further arguments (not applicable)}
}
\value{
Returns sample size \eqn{n},
number of covariates \eqn{p},
information on dichotomisation,
tuned scaling parameter (sigma),
tuned weighting parameter (pi),
and corresponding loss.
}
\description{
Prints summary of cornet object.
}
\examples{
n <- 100; p <- 200
y <- rnorm(n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
net <- cornet(y=y,cutoff=0,X=X)
print(net)

}
