/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.listener;

import java.io.PrintStream;
import java.util.Locale;
import org.corehunter.CoreHunterListener;
import org.jamesframework.core.problems.constraints.validations.Validation;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.search.Search;
import org.jamesframework.core.subset.SubsetSolution;

public class SimpleCoreHunterListener
implements CoreHunterListener {
    private static final String DEFAULT_PREFIX = "";
    private String prefix;
    private PrintStream printStream;

    public SimpleCoreHunterListener() {
        this(System.err);
    }

    public SimpleCoreHunterListener(PrintStream printStream) {
        this.printStream = printStream;
        this.prefix = DEFAULT_PREFIX;
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void searchStarted(Search<? extends SubsetSolution> search) {
        this.printStream.format(Locale.US, "%sSearch : %s started%n", this.prefix, search.getName());
    }

    @Override
    public void searchStopped(Search<? extends SubsetSolution> search) {
        double t = search.getRuntime() / 1000L;
        long s = search.getSteps();
        this.printStream.format(Locale.US, "%sSearch : %s stopped after %.1f seconds and %d steps%n", this.prefix, search.getName(), t, s);
        this.printStream.format(Locale.US, "%sBest solution with evaluation : %f%n", this.prefix, search.getBestSolutionEvaluation().getValue());
        this.printStream.format(Locale.US, "%sBest solution with evaluation : %s%n", this.prefix, search.getBestSolution());
    }

    @Override
    public void newBestSolution(Search<? extends SubsetSolution> search, SubsetSolution newBestSolution, Evaluation newBestSolutionEvaluation, Validation newBestSolutionValidation) {
        this.printStream.format(Locale.US, "%sCurrent value: %f%n", this.prefix, newBestSolutionEvaluation.getValue());
    }

    @Override
    public void preprocessingStarted(String message) {
        this.printStream.format(Locale.US, "%s%s%n", this.prefix, message);
    }

    @Override
    public void preprocessingStopped(String message) {
        this.printStream.format("%s%s%n", this.prefix, message);
    }
}

