/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uno.informatics.common.ConversionException;
import uno.informatics.data.DataType;

public class ConversionUtilities {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssZ");
    private static String DEFAULT_DELIMITER = "&";

    public static final String convertToString(String value) {
        return value;
    }

    public static final Object convertToObject(String string) {
        try {
            return ConversionUtilities.convertToObject(string, 805);
        }
        catch (ConversionException e) {
            return string;
        }
    }

    public static final Object convertToObject(String string, int types) throws ConversionException {
        Object value = null;
        if (string != null) {
            if (value == null && (types & 2) != 0) {
                value = ConversionUtilities.convertToShortInternal(string);
            }
            if (value == null && (types & 4) != 0) {
                value = ConversionUtilities.convertToIntegerInternal(string);
            }
            if (value == null && (types & 8) != 0) {
                value = ConversionUtilities.convertToLongInternal(string);
            }
            if (value == null && (types & 0x10) != 0) {
                value = ConversionUtilities.convertToFloatInternal(string);
            }
            if (value == null && (types & 0x20) != 0) {
                value = ConversionUtilities.convertToDoubleInternal(string);
            }
            if (value == null && (types & 0x40) != 0) {
                value = ConversionUtilities.convertToBigIntegerInternal(string);
            }
            if (value == null && (types & 0x80) != 0) {
                value = ConversionUtilities.convertToBigDecimalInternal(string);
            }
            if (value == null && (types & 1) != 0) {
                value = ConversionUtilities.convertToBooleanInternal(string);
            }
            if (value == null && (types & 0x100) != 0) {
                value = ConversionUtilities.convertToDateInternal(string);
            }
            if (value == null && (types & 0x200) != 0) {
                value = string;
            }
            if (value == null) {
                throw new ConversionException("Can not convert to Object using requested types " + ConversionUtilities.getTypesNames(types) + "!");
            }
        }
        return value;
    }

    public static List<String> getTypesNames(int types) {
        LinkedList<String> labels = new LinkedList<String>();
        if ((types & 2) != 0) {
            labels.add(DataType.SHORT.getName());
        }
        if ((types & 4) != 0) {
            labels.add(DataType.INTEGER.getName());
        }
        if ((types & 2) != 0) {
            labels.add(DataType.SHORT.getName());
        }
        if ((types & 8) != 0) {
            labels.add(DataType.LONG.getName());
        }
        if ((types & 0x10) != 0) {
            labels.add(DataType.FLOAT.getName());
        }
        if ((types & 0x20) != 0) {
            labels.add(DataType.DOUBLE.getName());
        }
        if ((types & 0x40) != 0) {
            labels.add(DataType.BIG_INTEGER.getName());
        }
        if ((types & 0x80) != 0) {
            labels.add(DataType.BIG_DECIMAL.getName());
        }
        if ((types & 1) != 0) {
            labels.add(DataType.BOOLEAN.getName());
        }
        if ((types & 0x100) != 0) {
            labels.add(DataType.DATE.getName());
        }
        if ((types & 0x200) != 0) {
            labels.add(DataType.STRING.getName());
        }
        return labels;
    }

    public static final Number convertToNumber(String string, int types) throws ConversionException {
        Number value = null;
        if (string != null) {
            if (value == null && (types & 2) != 0) {
                value = ConversionUtilities.convertToShortInternal(string);
            }
            if (value == null && (types & 4) != 0) {
                value = ConversionUtilities.convertToIntegerInternal(string);
            }
            if (value == null && (types & 8) != 0) {
                value = ConversionUtilities.convertToLongInternal(string);
            }
            if (value == null && (types & 0x10) != 0) {
                value = ConversionUtilities.convertToFloatInternal(string);
            }
            if (value == null && (types & 0x20) != 0) {
                value = ConversionUtilities.convertToDoubleInternal(string);
            }
            if (value == null && (types & 0x40) != 0) {
                value = ConversionUtilities.convertToBigIntegerInternal(string);
            }
            if (value == null && (types & 0x80) != 0) {
                value = ConversionUtilities.convertToBigDecimalInternal(string);
            }
            if (value == null) {
                throw new ConversionException("Can not convert to Number using requested types " + ConversionUtilities.getTypesNames(types) + "!");
            }
        }
        return value;
    }

    public static final BigDecimal convertToBigDecimal(String string) throws ConversionException {
        BigDecimal value = null;
        if (string != null) {
            try {
                value = new BigDecimal(string);
            }
            catch (NumberFormatException e) {
                throw new ConversionException(e.getMessage(), e);
            }
        }
        return value;
    }

    public static final BigInteger convertToBigInteger(String string) throws ConversionException {
        BigInteger value = null;
        if (string != null) {
            try {
                value = new BigInteger(string);
            }
            catch (NumberFormatException e) {
                throw new ConversionException(e.getMessage(), e);
            }
        }
        return value;
    }

    public static final Double convertToDouble(String string) throws ConversionException {
        Double value = null;
        if (string != null) {
            try {
                value = Double.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ConversionException(e.getMessage(), e);
            }
        }
        return value;
    }

    public static final Float convertToFloat(String string) throws ConversionException {
        Float value = null;
        if (string != null) {
            try {
                value = Float.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ConversionException(e.getMessage(), e);
            }
        }
        return value;
    }

    public static final Long convertToLong(String string) throws ConversionException {
        Long value = null;
        if (string != null) {
            try {
                value = Long.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ConversionException(e.getMessage(), e);
            }
        }
        return value;
    }

    public static final Integer convertToInteger(String string) throws ConversionException {
        Integer value = null;
        if (string != null) {
            try {
                value = Integer.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ConversionException(e.getMessage(), e);
            }
        }
        return value;
    }

    public static final Short convertToShort(String string) throws ConversionException {
        Short value = null;
        if (string != null) {
            try {
                value = Short.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ConversionException(e.getMessage(), e);
            }
        }
        return value;
    }

    public static final Boolean convertToBoolean(String string) throws ConversionException {
        Boolean value = null;
        if (string != null) {
            if (TRUE.equals(string.toLowerCase())) {
                return true;
            }
            if (FALSE.equals(string.toLowerCase())) {
                return false;
            }
        }
        return value;
    }

    public static final Date convertToDate(String value) throws ConversionException {
        if (value != null) {
            try {
                return DATE_FORMAT.parse(value);
            }
            catch (Exception e) {
                try {
                    return new Date(value);
                }
                catch (Exception e2) {
                    throw new ConversionException(e2);
                }
            }
        }
        return null;
    }

    public static final String convertToString(Object value) {
        if (value != null) {
            if (value instanceof Date) {
                return DATE_FORMAT.format((Date)value);
            }
            return value.toString();
        }
        return null;
    }

    public static final Double convertToDouble(Object value) throws ConversionException {
        if (value != null) {
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof String) {
                return ConversionUtilities.convertToDouble((String)value);
            }
            throw new ConversionException("Can not convert value to double : " + value);
        }
        return null;
    }

    public static final Integer convertToInteger(Object value) throws ConversionException {
        if (value != null) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                return ConversionUtilities.convertToInteger((String)value);
            }
            throw new ConversionException("Can not convert value to integer : " + value);
        }
        return null;
    }

    public static List<Short> convertToShortList(List<String> values) throws ConversionException {
        ArrayList<Short> list = new ArrayList<Short>();
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            list.add(ConversionUtilities.convertToShort(iterator.next()));
        }
        return list;
    }

    public static List<Integer> convertToIntegerList(List<String> values) throws ConversionException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            list.add(ConversionUtilities.convertToInteger(iterator.next()));
        }
        return list;
    }

    public static List<Long> convertToLongList(List<String> values) throws ConversionException {
        ArrayList<Long> list = new ArrayList<Long>();
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            list.add(ConversionUtilities.convertToLong(iterator.next()));
        }
        return list;
    }

    public static List<Float> convertToFloatList(List<String> values) throws ConversionException {
        ArrayList<Float> list = new ArrayList<Float>();
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            list.add(ConversionUtilities.convertToFloat(iterator.next()));
        }
        return list;
    }

    public static List<Double> convertToDoubleList(List<String> values) throws ConversionException {
        ArrayList<Double> list = new ArrayList<Double>();
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            list.add(ConversionUtilities.convertToDouble(iterator.next()));
        }
        return list;
    }

    public static List<Object> convertToObjectList(List<String> values, int type) throws ConversionException {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            list.add(ConversionUtilities.convertToObject(iterator.next(), type));
        }
        return list;
    }

    public static List<Object> convertToObjectList(List<String> values, int[] types) throws ConversionException {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator<String> iterator = values.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (i < types.length) {
                list.add(ConversionUtilities.convertToObject(iterator.next(), types[i]));
            } else {
                list.add(ConversionUtilities.convertToObject(iterator.next()));
            }
            ++i;
        }
        return list;
    }

    public static final int getDataType(String string) {
        int datatype = 0;
        if (string != null) {
            datatype = 512;
            if (ConversionUtilities.convertToShortInternal(string) != null) {
                datatype |= 2;
            }
            if (ConversionUtilities.convertToIntegerInternal(string) != null) {
                datatype |= 4;
            }
            if (ConversionUtilities.convertToLongInternal(string) != null) {
                datatype |= 8;
            }
            if (ConversionUtilities.convertToFloatInternal(string) != null) {
                datatype |= 0x10;
            }
            if (ConversionUtilities.convertToDoubleInternal(string) != null) {
                datatype |= 0x20;
            }
            if (ConversionUtilities.convertToBigIntegerInternal(string) != null) {
                datatype |= 0x40;
            }
            if (ConversionUtilities.convertToBigDecimalInternal(string) != null) {
                datatype |= 0x80;
            }
            if (ConversionUtilities.convertToBooleanInternal(string) != null) {
                datatype |= 1;
            }
            if (ConversionUtilities.convertToDateInternal(string) != null) {
                datatype |= 0x100;
            }
        }
        return datatype;
    }

    public static final List<Integer> getDataTypes(List<String> strings) {
        ArrayList<Integer> datatypes;
        if (strings != null) {
            datatypes = new ArrayList(strings.size());
            Iterator<String> iterator = strings.iterator();
            while (iterator.hasNext()) {
                datatypes.add(ConversionUtilities.getDataType(iterator.next()));
            }
        } else {
            datatypes = new ArrayList<Integer>();
        }
        return datatypes;
    }

    public static final int[] getDataTypes(String[] strings) {
        int[] datatypes;
        if (strings != null) {
            datatypes = new int[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                datatypes[i] = ConversionUtilities.getDataType(strings[i]);
            }
        } else {
            datatypes = new int[]{};
        }
        return datatypes;
    }

    public static final List<Integer> getDataTypes(List<String> strings, List<Integer> currentDatatypes) {
        ArrayList<Integer> datatypes;
        if (strings != null && currentDatatypes != null && strings.size() == currentDatatypes.size()) {
            datatypes = new ArrayList(strings.size());
            Iterator<String> iterator = strings.iterator();
            Iterator<Integer> iterator2 = currentDatatypes.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                datatypes.add(iterator2.next() & ConversionUtilities.getDataType(iterator.next()));
            }
        } else {
            datatypes = new ArrayList<Integer>(currentDatatypes);
        }
        return datatypes;
    }

    public static final int[] getDataTypes(String[] strings, int[] currentDatatypes) {
        int[] datatypes;
        if (strings != null && currentDatatypes != null && strings.length == currentDatatypes.length) {
            datatypes = new int[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                datatypes[i] = currentDatatypes[i] & ConversionUtilities.getDataType(strings[i]);
            }
        } else {
            datatypes = currentDatatypes;
        }
        return datatypes;
    }

    private static final BigDecimal convertToBigDecimalInternal(String string) {
        try {
            return ConversionUtilities.convertToBigDecimal(string);
        }
        catch (ConversionException e) {
            return null;
        }
    }

    private static final BigInteger convertToBigIntegerInternal(String string) {
        try {
            return ConversionUtilities.convertToBigInteger(string);
        }
        catch (ConversionException e) {
            return null;
        }
    }

    private static final Double convertToDoubleInternal(String string) {
        try {
            return ConversionUtilities.convertToDouble(string);
        }
        catch (ConversionException e) {
            return null;
        }
    }

    private static final Float convertToFloatInternal(String string) {
        try {
            return ConversionUtilities.convertToFloat(string);
        }
        catch (ConversionException e) {
            return null;
        }
    }

    private static final Long convertToLongInternal(String string) {
        try {
            return ConversionUtilities.convertToLong(string);
        }
        catch (ConversionException e) {
            return null;
        }
    }

    private static final Integer convertToIntegerInternal(String string) {
        try {
            return ConversionUtilities.convertToInteger(string);
        }
        catch (ConversionException e) {
            return null;
        }
    }

    private static final Short convertToShortInternal(String string) {
        try {
            return ConversionUtilities.convertToShort(string);
        }
        catch (ConversionException e) {
            return null;
        }
    }

    private static final Boolean convertToBooleanInternal(String string) {
        try {
            return ConversionUtilities.convertToBoolean(string);
        }
        catch (ConversionException e) {
            return null;
        }
    }

    private static final Date convertToDateInternal(String string) {
        try {
            return ConversionUtilities.convertToDate(string);
        }
        catch (ConversionException e) {
            return null;
        }
    }
}

