% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rebindensity.R
\name{rebindensity}
\alias{rebindensity}
\title{Re-bin density histograms}
\usage{
rebindensity(x, y, xout)
}
\arguments{
\item{x}{n-vector giving the mid-points of the input histogram bins, must be equally spaced}

\item{y}{n-vector giving the values of the input histogram values}

\item{xout}{m-vector giving the mid-points of the output histogram bins, must be equally spaced}
}
\value{
m-vector of y-values associated with the bins specified by xout.
}
\description{
Transform density histogram data into histogram data with different bins
}
\examples{
# original binning
x = seq(0.5,4.5)
y = seq(5)
plot(x,y,xlim=c(-1,6),ylim=c(0,6),pch=16)
lines(histcoord(x,y),lwd=3)

# rebinning
xout = seq(0.125,4.875,0.25)
yout = rebindensity(x,y,xout)
points(xout,yout,col='red',pch=16)
lines(histcoord(xout,yout),col='red')

}
\author{
Danail Obreschkow
}
