% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convoSPAT_paramEst.R
\name{make_local_lik}
\alias{make_local_lik}
\title{Constructor functions for local parameter estimation.}
\usage{
make_local_lik(locations, cov.model, data, Xmat, nugg2.var = matrix(0,
  nrow(locations), nrow(locations)), tausq = 0, kappa = 0.5,
  fixed = rep(FALSE, 6), method = "reml", local.aniso = TRUE,
  fix.tausq = FALSE, fix.kappa = FALSE)
}
\arguments{
\item{locations}{A matrix of locations.}

\item{cov.model}{String; the covariance model.}

\item{data}{A vector or matrix of data to use in the likelihood
calculation.}

\item{Xmat}{The design matrix for the mean model.}

\item{nugg2.var}{Fixed values for the variance/covariance of the second nugget term; defaults
to a matrix of zeros.}

\item{tausq}{Scalar; fixed value for the nugget variance (when
\code{fix.tausq = TRUE}).}

\item{kappa}{Scalar; fixed value for the smoothness (when \code{fix.kappa = TRUE}).}

\item{fixed}{Logical vector of \code{FALSE} values; length corresponds to the number
of parameters to be estimated.}

\item{method}{Indicates the estimation method, either maximum likelihood (\code{"ml"})
or restricted maximum likelihood (\code{"reml"}).}

\item{local.aniso}{Logical; indicates if the local covariance should be
anisotropic (\code{TRUE}) or isotropic (\code{FALSE}). Defaults to \code{TRUE}.}

\item{fix.tausq}{Logical; indicates whether the default nugget term
(tau^2) should be fixed (\code{TRUE}) or estimated (\code{FALSE}). Defaults to
\code{FALSE}.}

\item{fix.kappa}{Logical; indicates if the kappa parameter should be
fixed (\code{TRUE}) or estimated (\code{FALSE}). Defaults to \code{FALSE}
(only valid for \code{cov.model = "matern"} and \code{cov.model = "cauchy"}).}
}
\value{
This function returns another function for use in \code{optim}.
}
\description{
This function generates another function to be used within \code{optim} to
obtain maximum likelihood estimates of covariance (and possibly mean) parameters.
The function includes options for
(1) maximum likelihood (\code{"ml"}) vs. restricted maximum likelihood
    (\code{"reml"}),
(2) smoothness (\code{kappa}): models without smoothness vs. estimating the
    smoothness vs. using fixed smoothness,
(3) locally isotropic vs. locally anisotropic, and
(4) fixed nugget variance (\code{tausq}): fixed vs. estimated.
}
\examples{
\dontrun{
make_local_lik( locations, cov.model, data, Xmat )
}

}

