% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_funs.R
\name{convey_prep}
\alias{convey_prep}
\title{prepare svydesign and svyrep.design objects for the convey package}
\usage{
convey_prep(design)
}
\arguments{
\item{design}{a survey design object of the library survey.}
}
\value{
the same survey object with a \code{full_design} attribute as the storage space for the unsubsetted survey design
}
\description{
stores the full survey design (needed for convey functions that use a global poverty threshold) within the design.  this function must be run immediately after the full design object creation with \code{svydesign} or \code{svrepdesign}
}
\details{
functions in the convey package that use a global poverty threshold require the complete (pre-subsetted) design in order to calculate variances correctly.  this function stores the full design object as a separate attribute so that functions from the \code{survey} package such as \code{subset} and \code{svyby} do not disrupt the calculation of error terms.
}
\examples{

library(survey)
library(laeken)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design: convey_prep must be run as soon as the linearized design has been created
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep( des_eusilc )
# now this linearized design object is ready for analysis!

# # # CORRECT usage example # # #
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep( des_eusilc )
sub_eusilc <- subset( des_eusilc , age > 20 )
# since convey_prep() was run immediately after creating the design
# this will calculate the variance accurately
SE( svyarpt( ~ eqincome , sub_eusilc ) )
# # # end of CORRECT usage example # # #

# # # INCORRECT usage example # # #
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
sub_eusilc <- subset( des_eusilc , age > 20 )
sub_eusilc <- convey_prep( sub_eusilc )
# since convey_prep() was not run immediately after creating the design
# this will make the variance wrong
SE( svyarpt( ~ eqincome , sub_eusilc ) )
# # # end of INCORRECT usage example # # #

}
\author{
Djalma Pessoa and Anthony Damico
}
\keyword{survey}
