% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/points2par.R
\name{points2par}
\alias{points2par}
\title{From points to parameters of a straight line}
\usage{
points2par(point1, point2)
}
\arguments{
\item{point1}{collection abscissa ,ordinate.}

\item{point2}{collection abscissa ,ordinate.}
}
\value{
collection made by (intercept, slope)
}
\description{
Given two points on a plane, parameters of a straight line are calculated.
}
\examples{

# Example 1
require(tibble)
myTB <- tribble(
    ~time , ~indic,
    1    ,   25,
    10   ,   5,
    1,       10,
    10,       3
    )
resparamIT1 <- points2par(as.numeric(myTB[1,]),as.numeric(myTB[2,]))

# Example 2
myTB1 <- tribble(
    ~time , ~indic,
    2    ,   25,
    16   ,   5,
    1,       9,
    10,       3,
    34,       4
    )
resparamIT2 <- points2par(as.numeric(myTB1[1,]),as.numeric(myTB1[2,]))

# Example 3
myTB2 <- tribble(
    ~time , ~indic,
    5    ,   2,
    1   ,   15,
    11,       19,
    20,       33,
    25,       14
    )
resparamIT3 <- points2par(as.numeric(myTB2[1,]),as.numeric(myTB2[2,]))

}
