% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scheffe_type_CIs_rxc.R
\name{Scheffe_type_CIs_rxc}
\alias{Scheffe_type_CIs_rxc}
\title{The ScheffE-type simultaneous confidence intervals for the differences pi_1|i - pi_1|j}
\usage{
Scheffe_type_CIs_rxc(n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (an rx2 vector)}

\item{alpha}{the nominal level, e.g. 0.05 for 95# CIs}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing lower, upper and point estimates of the statistic
}
\description{
The ScheffE-type simultaneous confidence intervals for the differences pi_1|i - pi_1|j

Described in Chapter 7 "The rxc Table"
}
\examples{
# Example: Treatment for ear infection
n <- rbind(c(40, 25), c(54, 7), c(63, 10))
Scheffe_type_CIs_rxc(n)
}
