% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOVER_R_Wilson_CI_OR_2x2.R
\name{MOVER_R_Wilson_CI_OR_2x2}
\alias{MOVER_R_Wilson_CI_OR_2x2}
\title{The MOVER-R Wilson confidence interval for the odds ratio}
\usage{
MOVER_R_Wilson_CI_OR_2x2(n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{printresults}{display results (F = no, 1T= yes)}
}
\value{
A data frame containing lower, upper and point estimates of the statistic
}
\description{
The MOVER-R Wilson confidence interval for the odds ratio

Described in Chapter 4 "The 2x2 Table"
}
\examples{
# A case-control study of GADA exposure on IPEX syndrome (Lampasona et al., 2013):
n <- matrix(c(9,4,4,10), nrow=2, byrow=TRUE)
MOVER_R_Wilson_CI_OR_2x2(n)

# The association between CHRNA4 genotype and XFS (Ritland et al., 2007):
n <- matrix(c(0,16,15,57), nrow=2, byrow=TRUE)
MOVER_R_Wilson_CI_OR_2x2(n)

}
