% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content_id.R
\name{content_id}
\alias{content_id}
\title{Generate a content uri for a local file}
\usage{
content_id(file, algos = default_algos(), raw = TRUE)
}
\arguments{
\item{file}{path to the file, URL, or a \link[base:connections]{base::file} connection}

\item{algos}{Which algorithms should we compute contentid for? Default "sha256",
see details.}

\item{raw}{Logical, should compressed data be left as compressed binary?}
}
\value{
a content identifier uri
}
\description{
Generate a content uri for a local file
}
\details{
See \url{https://github.com/hash-uri/hash-uri} for an overview of the
content uri format and comparison to similar approaches.

Compressed file streams will have different raw (binary) and uncompressed
hashes. Set \code{raw = FALSE} to allow \link[base:connections]{base::file} connection to uncompress
common compression streams before calculating the hash, but this will
be slower.
}
\examples{

## local file
path <- system.file("extdata", "vostok.icecore.co2", package = "contentid")
content_id(path)
\donttest{

content_id(paste0("https://knb.ecoinformatics.org/knb/d1/mn/v2/object/",
                  "ess-dive-457358fdc81d3a5-20180726T203952542"))
}


}
