## ----knitr-setup, include = FALSE-----------------------------------------------------------------
require(container)
knitr::opts_chunk$set(
  comment = "#",
  prompt = F,
  tidy = FALSE,
  cache = FALSE,
  collapse = T
)

old <- options(width = 100L)

## -------------------------------------------------------------------------------------------------
# Mimic stack
s = deque()
s
ref_add(s, 1)
ref_add(s, 2)
s

ref_pop(s)
ref_pop(s)
s

## -------------------------------------------------------------------------------------------------
# Mimic queue
q = deque()
q
ref_add(q, 1)
ref_add(q, 2)
q

ref_popleft(q)
ref_popleft(q)
q

## -------------------------------------------------------------------------------------------------
d = as.deque(1:4)
d
rev(d)
rotate(d, 2)

## -------------------------------------------------------------------------------------------------
s1 = setnew(1, "1", 2, cars)
s2 = setnew(1,      2, 3, iris)

s1 & s2
s1 | s2
s1 - s2

## -------------------------------------------------------------------------------------------------
s1 = setnew(1, 2, 3)
s2 = setnew(2, 1, 3)
s1 == s2

## -------------------------------------------------------------------------------------------------
s1[1:2]
s2[1:2]

## -------------------------------------------------------------------------------------------------
os1 = as.orderedset(s1)
os2 = as.orderedset(s2)
os1
os2
os1 == os2

## -------------------------------------------------------------------------------------------------
d = dict(z = 2, a = 10)
d

## -------------------------------------------------------------------------------------------------
d[["x"]] = 1
d

## ----error = TRUE---------------------------------------------------------------------------------
try({
add(d, z = 3)
})

## -------------------------------------------------------------------------------------------------
d[["z"]] = 3
replace_at(d, z = 3)
update(d, dict(z = 3))

## -------------------------------------------------------------------------------------------------
d["x", "a"]
d[2:1]

add(d, b = 3)[2:1]

## ----include = FALSE----------------------------------------------------------
options(old)

