% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constellate_criteria.R
\name{constellate_criteria}
\alias{constellate_criteria}
\title{Flags events that occur at every time measurement}
\usage{
constellate_criteria(..., criteria_names, window_hours, join_key, time_var,
  final_event = FALSE)
}
\arguments{
\item{...}{An arbitrary number of time series data frames that each include
the columns 'join_key' and 'time_var'}

\item{criteria_names}{A vector of strings specifying the name of each
event. The order of strings in the vector should align with the order of
data frames passed in '...'.}

\item{window_hours}{A single numeric or vector of numerics specifying the
number of hours to search for each event. The order of numerics in the
vector should align with the order of data frames passed in '...'.}

\item{join_key}{A string name of the column to join all time series data
frames}

\item{time_var}{A string name of the time stamp column in all time series
data frames}

\item{final_event}{A boolean specifying where or not to build an indicator
variable for the final event in the sequence}
}
\value{
A data.frame, data.table with indicator variables for each event.
 The total number of rows is the unique number of time stamps for
 all combined measurements.
}
\description{
A function that reads in multiple time series data frames for various events
 and builds indicator variables for each event that occurs within a
 specified number of hours within every timestamp.
}
\details{
The user passes an arbitrary number of time series data frames and
 specifies a name and number of hours to search for each event. The user
 must also specify a variable to use to join the tables, and the time stamp
 variable. Finally, the user can select whether or not to build a final
 indicator variable that shows the final event in the sequence.

This function extends the constellate function to address a different set
 of questions, including: 1) at a specific timestamp, which event do and do
 not occur? 2) which final event triggers the combination of events that
 I'm interested in? This function can be used to calculate risk scores
 at any measurement timestamp by building a new variable after the function
 runs and returns the new data frame. The risk score can add up the
 crieteria or can be a linear combination of criteria.
}
\section{Imported functions}{

fastPOSIXct() from fasttime package and data.table syntax
}

\section{Errors}{

This function returns errors for:
\itemize{
 \item missing arguments (only final_event has a default value)
 \item passing a window_hours value that is not numeric or negative or 0
 \item passing join_key or time_var values that are not column names in all
   time series data frames
 \item passing an invalid number of criteria_names (must be equal to number
   of event data frames)
 \item passing an invalid number of window_hours values (1 or the number of
   event data frames).
}
}

\examples{
library(data.table)
temp <- as.data.table(vitals[VARIABLE == "TEMPERATURE"])
pulse <- as.data.table(vitals[VARIABLE == "PULSE"])
resp <- as.data.table(vitals[VARIABLE == "RESPIRATORY_RATE"])

# Pass single window_hours
constellate_criteria(temp, pulse, resp, criteria_names = c("TEMPERATURE",
 "PULSE", "RESPIRATORY_RATE"), window_hours = 6, join_key = "PAT_ID",
 time_var = "RECORDED_TIME")
# Pass vector for window_hours
constellate_criteria(temp, pulse, resp, criteria_names = c("TEMPERATURE",
 "PULSE", "RESPIRATORY_RATE"), window_hours = c(6,6,6), join_key = "PAT_ID",
 time_var = "RECORDED_TIME")
# Add final event variable
constellate_criteria(temp, pulse, resp, criteria_names = c("TEMPERATURE",
 "PULSE", "RESPIRATORY_RATE"), window_hours = c(6,6,6), join_key =
 "PAT_ID", time_var = "RECORDED_TIME", final_event = TRUE)

}
