% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrations.R
\name{velocityInfoConos}
\alias{velocityInfoConos}
\title{RNA velocity analysis on samples integrated with conos
Create a list of objects to pass into gene.relative.velocity.estimates function from the velocyto.R package}
\usage{
velocityInfoConos(
  cms.list,
  con,
  clustering = NULL,
  groups = NULL,
  n.odgenes = 2000,
  verbose = TRUE,
  min.max.cluster.average.emat = 0.2,
  min.max.cluster.average.nmat = 0.05,
  min.max.cluster.average.smat = 0.01
)
}
\arguments{
\item{cms.list}{list of velocity files written out as cell.counts.matrices.rds files by running dropest with -V option}

\item{con}{conos object (after creating an embedding and running leiden clustering)}

\item{clustering}{name of clustering in the conos object to use (default=NULL). Either 'clustering' or 'groups' must be provided.}

\item{groups}{set of clusters to use (default=NULL). Ignored if 'clustering' is not NULL.}

\item{n.odgenes}{numeric Number of overdispersed genes to use for PCA (default=2000).}

\item{verbose}{boolean Whether to use verbose mode (default=TRUE)}

\item{min.max.cluster.average.emat}{Required minimum average expression count for emat, the spliced (exonic) count matrix (default=0.2). Note: no normalization is perfomed. See the parameter 'min.max.cluster.average' in the function 'filter.genes.by.cluster.expression.'}

\item{min.max.cluster.average.nmat}{Required minimum average expression count for nmat, the unspliced (nascent) count matrix (default=0.05). Note: no normalization is perfomed. See the parameter 'min.max.cluster.average' in the function 'filter.genes.by.cluster.expression.'}

\item{min.max.cluster.average.smat}{Required minimum average expression count for smat, the spanning read matrix (used in offset calculations) (default=0.01). Note: no normalization is perfomed. See the parameter 'min.max.cluster.average' in the function 'filter.genes.by.cluster.expression.'}
}
\value{
List with cell distances, combined spliced expression matrix, combined unspliced expression matrix, combined matrix of spanning reads, cell colors for clusters and embedding (taken from conos)
}
\description{
RNA velocity analysis on samples integrated with conos
Create a list of objects to pass into gene.relative.velocity.estimates function from the velocyto.R package
}
