% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{download_bundle}
\alias{download_bundle}
\title{Download a Bundle from Deployed Connect Content}
\usage{
download_bundle(
  content,
  filename = fs::file_temp(pattern = "bundle", ext = ".tar.gz"),
  bundle_id = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{content}{A Content object}

\item{filename}{Optional. The output bundle path}

\item{bundle_id}{Optional. A string representing the bundle_id to download.
If NULL, will use the currently active bundle.}

\item{overwrite}{Optional. Default FALSE. Whether to overwrite the target location if it already exists}
}
\value{
Bundle A bundle object
}
\description{
Downloads a Content item's active bundle, or (optionally) one of its other bundles.
}
\seealso{
Other deployment functions: 
\code{\link{bundle_dir}()},
\code{\link{bundle_path}()},
\code{\link{bundle_static}()},
\code{\link{deploy}()},
\code{\link{poll_task}()}
}
\concept{deployment functions}
