% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{deploy}
\alias{deploy}
\alias{deploy_current}
\title{Deploy a bundle}
\usage{
deploy(
  connect,
  bundle,
  name = create_random_name(),
  title = name,
  guid = NULL,
  ...,
  .pre_deploy = {
 }
)

deploy_current(content)
}
\arguments{
\item{connect}{A Connect object}

\item{bundle}{A Bundle object}

\item{name}{The unique name for the content on the server}

\item{title}{optional The title to be used for the content on the server}

\item{guid}{optional The GUID if the content already exists on the server}

\item{...}{Additional arguments passed along to the content creation}

\item{.pre_deploy}{An expression to execute before deploying the new bundle. The variables \code{content} and \code{bundle_id} are supplied}

\item{content}{A Content object}
}
\value{
Task A task object
}
\description{
Deploys a bundle (tarball) to an Posit Connect server. If not provided,
\code{name} (a unique identifier) will be an auto-generated alphabetic string. If
deploying to an existing endpoint, you can set \code{name} or \code{guid} to the
desired content.
}
\details{
This function accepts the same arguments as \code{connectapi::content_update()}.

\code{deploy_current()} is a helper to easily redeploy the currently active bundle
for an existing content item.
}
\examples{
\dontrun{
client <- connect()

# beware bundling big directories, like `renv/`, `data/`, etc.
bnd <- bundle_dir(".")

deploy(client, bnd)
}
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

client <- connect(prefix = "TEST_1")
bnd <- bundle_path(system.file("tests/testthat/examples/static.tar.gz", package = "connectapi"))
deploy(client, bnd)
\dontshow{\}) # examplesIf}
}
\seealso{
connectapi::content_update

Other deployment functions: 
\code{\link{bundle_dir}()},
\code{\link{bundle_path}()},
\code{\link{bundle_static}()},
\code{\link{download_bundle}()},
\code{\link{poll_task}()}
}
\concept{deployment functions}
