config.json <- system.file('extdata', 'config.json', package='configr')
config.yml <- system.file('extdata', 'config.yml', package='configr')
config.ini <- system.file('extdata', 'config.ini', package='configr')
flog.info(sprintf("Debug:%s config file type:%s", config.json, get.config.type(config.json)))
flog.info("Debug:read.config(config.json)")
print(read.config(config.json))
flog.info("Debug:read.config(config.yml)")
print(read.config(config.yml))
flog.info("Debug:read.config(config.ini)")
print(read.config(config.ini))

flog.info("Debug:eval.config(file=config.json)")
print(eval.config(file = config.json))
flog.info("Debug:eval.config(file=config.yml)")
print(eval.config(file = config.yml))
flog.info("Debug:eval.config(file=config.ini)")
print(eval.config(file = config.ini))

flog.info("Debug:eval.config.groups(file=config.json)")
print(eval.config.groups(file = config.json))
flog.info("Debug:eval.config.groups(file=config.yml)")
print(eval.config.groups(file = config.yml))
flog.info("Debug:eval.config.groups(file=config.ini)")
print(eval.config.groups(file = config.ini))

flog.info("Debug:eval.config.merge.groups(file=config.json)")
print(eval.config.merge.groups(config.json))
flog.info("Debug:eval.config.merge.groups(file=config.yml)")
print(eval.config.merge.groups(config.json))
flog.info("Debug:eval.config.merge.groups(file=config.ini)")
print(eval.config.merge.groups(config.ini))

flog.info("Debug:eval.config.merge.groups(file=config.json,default)")
print(eval.config.merge.groups(config.json, "default"))
flog.info("Debug:eval.config.merge.groups(file=config.yml,default)")
print(eval.config.merge.groups(config.yml, "default"))
flog.info("Debug:eval.config.merge.groups(file=config.ini,default)")
print(eval.config.merge.groups(config.ini, "default"))


flog.info("Debug:config.list.merge(list(a=c(123,123),b=c(4,5,6),list(c=c(2,3,4))))")
list.left <- list(a=c(123,123), b=c(4,5,6))
list.right <- list(c=c(2,3,4))
print(config.list.merge(list.left, list.right))


flog.info("Debug:write.config(list(a=c(123,b=list(456))), '/tmp/test.yaml', write.type = 'yaml')")
list.test <- list(a=c(123,b=list(456)))
write.config(list.test, "/tmp/test.yaml", write.type = "yaml")
