% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autogenerated.R, R/condition.R
\name{assertion_message}
\alias{assertion_error}
\alias{assertion_message}
\alias{assertion_warning}
\alias{condition}
\alias{condition_error}
\alias{condition_message}
\alias{condition_warning}
\alias{deprecated_error}
\alias{deprecated_message}
\alias{deprecated_warning}
\alias{dimension_error}
\alias{dimension_message}
\alias{dimension_warning}
\alias{future_error}
\alias{future_message}
\alias{future_warning}
\alias{index_error}
\alias{index_message}
\alias{index_warning}
\alias{io_error}
\alias{io_message}
\alias{io_warning}
\alias{length_error}
\alias{length_message}
\alias{length_warning}
\alias{library_error}
\alias{library_message}
\alias{library_warning}
\alias{lookup_error}
\alias{lookup_message}
\alias{lookup_warning}
\alias{missing_error}
\alias{missing_message}
\alias{missing_warning}
\alias{name_error}
\alias{name_message}
\alias{name_warning}
\alias{runtime_error}
\alias{runtime_message}
\alias{runtime_warning}
\alias{type_error}
\alias{type_message}
\alias{type_warning}
\alias{value_error}
\alias{value_message}
\alias{value_warning}
\title{Generate a custom condition}
\usage{
assertion_message(message, call = sys.call(-1L), attach = NULL)

deprecated_message(message, call = sys.call(-1L), attach = NULL)

dimension_message(message, call = sys.call(-1L), attach = NULL)

future_message(message, call = sys.call(-1L), attach = NULL)

index_message(message, call = sys.call(-1L), attach = NULL)

io_message(message, call = sys.call(-1L), attach = NULL)

length_message(message, call = sys.call(-1L), attach = NULL)

library_message(message, call = sys.call(-1L), attach = NULL)

lookup_message(message, call = sys.call(-1L), attach = NULL)

missing_message(message, call = sys.call(-1L), attach = NULL)

name_message(message, call = sys.call(-1L), attach = NULL)

runtime_message(message, call = sys.call(-1L), attach = NULL)

type_message(message, call = sys.call(-1L), attach = NULL)

value_message(message, call = sys.call(-1L), attach = NULL)

assertion_warning(message, call = sys.call(-1L), attach = NULL)

deprecated_warning(message, call = sys.call(-1L), attach = NULL)

dimension_warning(message, call = sys.call(-1L), attach = NULL)

future_warning(message, call = sys.call(-1L), attach = NULL)

index_warning(message, call = sys.call(-1L), attach = NULL)

io_warning(message, call = sys.call(-1L), attach = NULL)

length_warning(message, call = sys.call(-1L), attach = NULL)

library_warning(message, call = sys.call(-1L), attach = NULL)

lookup_warning(message, call = sys.call(-1L), attach = NULL)

missing_warning(message, call = sys.call(-1L), attach = NULL)

name_warning(message, call = sys.call(-1L), attach = NULL)

runtime_warning(message, call = sys.call(-1L), attach = NULL)

type_warning(message, call = sys.call(-1L), attach = NULL)

value_warning(message, call = sys.call(-1L), attach = NULL)

assertion_error(message, call = sys.call(-1L), attach = NULL)

deprecated_error(message, call = sys.call(-1L), attach = NULL)

dimension_error(message, call = sys.call(-1L), attach = NULL)

future_error(message, call = sys.call(-1L), attach = NULL)

index_error(message, call = sys.call(-1L), attach = NULL)

io_error(message, call = sys.call(-1L), attach = NULL)

length_error(message, call = sys.call(-1L), attach = NULL)

library_error(message, call = sys.call(-1L), attach = NULL)

lookup_error(message, call = sys.call(-1L), attach = NULL)

missing_error(message, call = sys.call(-1L), attach = NULL)

name_error(message, call = sys.call(-1L), attach = NULL)

runtime_error(message, call = sys.call(-1L), attach = NULL)

type_error(message, call = sys.call(-1L), attach = NULL)

value_error(message, call = sys.call(-1L), attach = NULL)

condition(type, class = character(0L), message, call = sys.call(-1L))

condition_error(class, message, call = sys.call(-1L), attach = NULL)

condition_warning(class, message, call = sys.call(-1L), attach = NULL)

condition_message(class, message, call = sys.call(-1L), attach = NULL)
}
\arguments{
\item{message}{[\code{character(1)}]\cr
Information about the condition.}

\item{call}{[\code{call} | \code{NULL}]\cr
Call stack.}

\item{attach}{[ANY]\cr
Object to attach to the condition. Can be accessed via \code{cond$attached}
in a \code{\link[base]{tryCatch}} (see example).}

\item{type}{[\code{character(1)}]\cr
Should be one of \dQuote{error}, \dQuote{warning} or \dQuote{message}.}

\item{class}{[\code{character}]\cr
Class for the condition.
The functions \code{condition_error}, \code{condition_warning} and \code{condition_message}
automatically append the respective type with an underscore (see example).}
}
\value{
[\code{condition}].
}
\description{
\code{condition} creates a custom condition.
The functions \code{condition_message}, \code{condition_warning} and \code{condition_error}
are specialized to create conditions of type \dQuote{message}, \dQuote{warning} or \dQuote{error},
respectively. Furthermore, the constructors for some standardized conditions are predefined (see details).
}
\details{
The standardized conditions include:
\describe{
  \item{\dQuote{assertion}:}{Assertion (on user input) failed.}
  \item{\dQuote{deprecated}:}{Feature is deprecated.}
  \item{\dQuote{dimension}:}{Wrong dimension.}
  \item{\dQuote{future}:}{Feature is subject to change in the future.}
  \item{\dQuote{index}:}{Subscript out of range.}
  \item{\dQuote{io}:}{File/directory not found or accessible.}
  \item{\dQuote{length}:}{Wrong length.}
  \item{\dQuote{library}:}{Required package not installed.}
  \item{\dQuote{lookup}:}{Named subelement does not exist.}
  \item{\dQuote{missing}:}{Missing values.}
  \item{\dQuote{name}:}{Failed lookup of a global variable.}
  \item{\dQuote{runtime}:}{Something else which does not fit in any other category went wrong.}
  \item{\dQuote{type}:}{Unexpected type/class.}
  \item{\dQuote{value}:}{Inappropriate value.}
}
}
\examples{
# A simple IO error:
e = condition_error("io", "Failed to load file")
print(e)
class(e)

# To signal the condition, use message/warning/stop.
\dontrun{
message(e)
warning(e)
stop(e)
}

# These are equivalent (except the call):
w1 = condition("warning", "dimension_warning", "foo")
w2 = condition_warning("dimension", "foo")
w3 = tryCatch(dimension_warning("foo"), condition = function(e) e)

# Attach and retrieve additional information
f = function(x) {
  if(!is.numeric(x))
    assertion_error(" must be numeric", attach = x)
  x^2
}
f(1:10)

tryCatch(f(letters), assertion_error = function(e) {
  message("x must be numeric, but is ", typeof(e$attached))
})
}

