% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_boot.R
\name{curve_boot}
\alias{curve_boot}
\title{Generate Consonance Functions via Bootstrapping}
\usage{
curve_boot(
  data = data,
  func = func,
  method = "bca",
  replicates = 2000,
  steps = 1000,
  table = TRUE
)
}
\arguments{
\item{data}{Dataset that is being used to create a consonance function.}

\item{func}{Custom function that is used to create parameters of interest that
will be bootstrapped.}

\item{method}{The boostrap method that will be used to generate the functions.
Methods include "bca" which is the default and "t".}

\item{replicates}{Indicates how many bootstrap replicates are to be performed.
The defaultis currently 20000 but more may be desirable, especially to make
the functions more smooth.}

\item{steps}{Indicates how many consonance intervals are to be calculated at
various levels. For example, setting this to 100 will produce 100 consonance
intervals from 0 to 100. Setting this to 10000 will produce more consonance
levels. By default, it is set to 1000. Increasing the number substantially
is not recommended as it will take longer to produce all the intervals and
store them into a dataframe.}

\item{table}{Indicates whether or not a table output with some relevant
statistics should be generated. The default is TRUE and generates a table
which is included in the list object.}
}
\value{
A list with the dataframe of values in the first list and the table
in the second if table = TRUE.
}
\description{
Use the BCa bootstrap method and the t boostrap method from the bcaboot and boot packages
to generate consonance distrbutions.
}
\examples{

\donttest{
data(diabetes, package = "bcaboot")
Xy <- cbind(diabetes$x, diabetes$y)
rfun <- function(Xy) {
  y <- Xy[, 11]
  X <- Xy[, 1:10]
  return(summary(lm(y ~ X))$adj.r.squared)
}

x <- curve_boot(data = Xy, func = rfun, method = "bca", replicates = 200, steps = 1000)

ggcurve(data = x[[1]])
ggcurve(data = x[[3]])

plot_compare(x[[1]], x[[3]])
}

}
