% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numerate.R
\name{numerate}
\alias{numerate}
\alias{enumerate}
\alias{unnumerate}
\alias{mark}
\alias{unmark}
\alias{unzip_list}
\alias{zip_lists}
\title{Auxiliary functions for working with lists}
\usage{
numerate(x)

enumerate(x)

unnumerate(x, item = 2)

mark(x)

unmark(x, item = 2)

unzip_list(x)

zip_lists(...)
}
\arguments{
\item{x}{list or list of lists}

\item{item}{numeric number of list in which stored values}

\item{...}{lists which will be zipped}
}
\value{
list or list of lists
}
\description{
\itemize{
\item{numerate}{ returns list of lists. Each list consists of two elements:
sequential number of element and element. Reverse operation -
\code{unumerate}.}
\item{mark}{ returns list of lists. Each list consists of two elements: name of element and element. Reverse operation -
\code{unmark}.}
\item{zip_lists}{ combine lists side-by-sidy. Reverse operation - \code{unzip_list}.}
\item{unzip_list}{ It's similair to matrix transposition but for list of lists.}
}
}
\examples{
cities = c('Chicago', 'Detroit', 'Atlanta')
airports = c('ORD', 'DTW', 'ATL')
pairs = zip_lists(cities, airports)

str(pairs)
str(unzip_list(pairs))

str(numerate(cities))

named_list = c('Chicago' = 'ORD', 'Detroit' = 'DTW', 'Atlanta' = 'ATL')
str(mark(named_list))

}
