# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate Cartesian coordinates for 1-4 bonded atoms
#' 
#' @description
#' Consider atoms A-B-C-D forming a dihedral. 
#' Given coordinates for atoms A,B,C of the dihedral,
#' the dihedral angle, bond angle, and bond length, calculate the Cartesian coordinates
#' of atom D in the dihedral.
#'
#' @param prev_atoms a 3x3 matrix of coordinates for atoms A-B-C in dihedral, listed by row
#' @param length bond length between atoms C-D in dihedral 
#' @param bAngle planar bond angle between atoms B-C-D (in degrees)
#' @param tAngle dihedral angle formed by atoms A-B-C-D (in degrees)
#' 
#' @return
#' Returns the vector of coordinates for the fourth atom in the dihedral
#' 
#' @examples
#' prevAtoms <- matrix(c(50.051, 37.144, -4.723,
#'  50.044, 36.248, -3.559,
#'  51.296, 35.369, -3.476), nrow=3, ncol=3, byrow=TRUE)
#' calCo(prevAtoms, length=1.33, bAngle=116.8, tAngle=-25.3)
#' 
#' @export
#' 
calCo <- function(prev_atoms, length, bAngle, tAngle) {
    .Call(`_compas_calCo`, prev_atoms, length, bAngle, tAngle)
}

dfeval <- function(chain, atypes, etable) {
    .Call(`_compas_dfeval`, chain, atypes, etable)
}

RMSD <- function(x, y) {
    .Call(`_compas_RMSD`, x, y)
}

LRMSD <- function(xr, yr) {
    .Call(`_compas_LRMSD`, xr, yr)
}

#' Calculate dihedral angle formed by four atoms
#' 
#' @description
#' For Cartesian coordinates of atoms A-B-C-D, calculate the dihedral angle formed by viewing down the B-C axis.
#'
#' @param a length 3 vector of coordinates of atom A
#' @param b length 3 vector of coordinates of atom B
#' @param c length 3 vector of coordinates of atom C
#' @param d length 3 vector of coordinates of atom D
#' 
#' @return
#' Returns the dihedral angle (in degrees between -180 and 180).
#' 
#' @details
#' Similar to \link[bio3d]{torsion.xyz}, but with implementation in C++.
#'
#' @examples
#' torsion(c(50.051, 37.144, -4.723), c(50.044, 36.248, -3.559),
#'         c(51.296, 35.369, -3.476), c(51.930,35.119,-4.618))
#' 
#' @export
#' 
torsion <- function(a, b, c, d) {
    .Call(`_compas_torsion`, a, b, c, d)
}

