% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_MCMC_comparison_pages.R
\name{make_MCMC_comparison_pages}
\alias{make_MCMC_comparison_pages}
\title{Create html output with comparisons of MCMC results}
\usage{
make_MCMC_comparison_pages(
  comparisonResults,
  dir = tempdir(),
  pageComponents,
  modelName = "model",
  control,
  plot = TRUE
)
}
\arguments{
\item{comparisonResults}{An list of \code{MCMCresult} objects
such as returned by \code{\link{compareMCMCs}}.}

\item{dir}{A directory in which to place the html file and any
figure files used in it.  This defaults to tempdir() (which
will be erased when the R session is closed).
Use \code{dir = getwd()} to use current working directory.}

\item{pageComponents}{A list whose names are registered page
components and values are \code{TRUE} (to include a component) or
\code{FALSE} (to omit a component).  Components can also be omitted by
leaving them out of the list.}

\item{modelName}{A name to be used for the model in generated
output.}

\item{control}{A named list of control parameters.}

\item{plot}{\code{TRUE} to generate results, \code{FALSE} not to do so.  Use
of \code{FALSE} is useful if one wants to use the returned object
(including plottable components) in one's own way.}
}
\value{
A list of objects returned from each page component plugin.  For figures,
these contain a \code{plottable} object such as a \code{ggplot} object.  For text,
these contain information for text output such as an \code{xtable} object.
}
\description{
Create html output with comparisons of MCMC results
}
\details{
See package vignette for information about page components,
including about default page components and how to write and
register new page components.

To see built-in page components and their options, use
\code{as.list(getPageComponents())}.
}
