% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comorbidity.R
\name{comorbidity}
\alias{comorbidity}
\title{Comorbidity mapping.}
\usage{
comorbidity(x, id, code, map, assign0, labelled = TRUE, tidy.codes = TRUE)
}
\arguments{
\item{x}{A tidy \code{data.frame} (or a \code{data.table}; \code{tibble}s are supported too) with one column containing an individual ID and a column containing all diagnostic codes.
Extra columns other than ID and codes are discarded.
Column names must be syntactically valid names, otherwise they are forced to be so by calling the \code{\link[=make.names]{make.names()}} function.}

\item{id}{Column of \code{x} containing the individual ID.}

\item{code}{Column of \code{x} containing diagnostic codes.
Codes must be in upper case with no punctuation in order to be properly recognised.}

\item{map}{The mapping algorithm to be used (values are case-insensitive).
Possible values are the Charlson score with either ICD-10 or ICD-9-CM codes (\code{charlson_icd10_quan}, \code{charlson_icd9_quan}) and the Elixhauser score, again using either ICD-10 or ICD-9-CM (\code{elixhauser_icd10_quan}, \code{elixhauser_icd9_quan}).
These mapping are based on the paper by Quan et al. (2011).
It is also possible to obtain a Swedish (\code{charlson_icd10_se}) or Australian (\code{charlson_icd10_am}) modification of the Charlson score using ICD-10 codes.}

\item{assign0}{Apply a hierarchy of comorbidities: should a comorbidity be present in a patient with different degrees of severity, then the milder form will be assigned a value of 0.
By doing this, a type of comorbidity is not counted more than once in each patient.
The comorbidities that are affected by this argument are:
\itemize{
\item "Mild liver disease" (\code{mld}) and "Moderate/severe liver disease" (\code{msld}) for the Charlson score;
\item "Diabetes" (\code{diab}) and "Diabetes with complications" (\code{diabwc}) for the Charlson score;
\item "Cancer" (\code{canc}) and "Metastatic solid tumour" (\code{metacanc}) for the Charlson score;
\item "Hypertension, uncomplicated" (\code{hypunc}) and "Hypertension, complicated" (\code{hypc}) for the Elixhauser score;
\item "Diabetes, uncomplicated" (\code{diabunc}) and "Diabetes, complicated" (\code{diabc}) for the Elixhauser score;
\item "Solid tumour" (\code{solidtum}) and "Metastatic cancer" (\code{metacanc}) for the Elixhauser score.
}}

\item{labelled}{Attach labels to each comorbidity, compatible with the RStudio viewer via the \code{\link[utils:View]{utils::View()}} function.
Defaults to \code{TRUE}.}

\item{tidy.codes}{Tidy diagnostic codes?
If \code{TRUE}, all codes are converted to upper case and all non-alphanumeric characters are removed using the regular expression \code{[^[:alnum:]]}.
Defaults to \code{TRUE}.}
}
\value{
A data frame with \code{id}, columns relative to each comorbidity domain, comorbidity score, weighted comorbidity score, and categorisations of such scores, with one row per individual.

For the Charlson score, the following variables are included in the dataset:
\itemize{
\item The \code{id} variable as defined by the user;
\item \code{mi}, for myocardial infarction;
\item \code{chf}, for congestive heart failure;
\item \code{pvd}, for peripheral vascular disease;
\item \code{cevd}, for cerebrovascular disease;
\item \code{dementia}, for dementia;
\item \code{cpd}, for chronic pulmonary disease;
\item \code{rheumd}, for rheumatoid disease;
\item \code{pud}, for peptic ulcer disease;
\item \code{mld}, for mild liver disease;
\item \code{diab}, for diabetes without complications;
\item \code{diabwc}, for diabetes with complications;
\item \code{hp}, for hemiplegia or paraplegia;
\item \code{rend}, for renal disease;
\item \code{canc}, for cancer (any malignancy);
\item \code{msld}, for moderate or severe liver disease;
\item \code{metacanc}, for metastatic solid tumour;
\item \code{aids}, for AIDS/HIV.
Please note that we combine "chronic obstructive pulmonary disease" and "chronic other pulmonary disease" for the Swedish version of the Charlson index, for comparability (and compatibility) with other definitions/implementations.
}

Conversely, for the Elixhauser score the dataset contains the following variables:
\itemize{
\item The \code{id} variable as defined by the user;
\item \code{chf}, for congestive heart failure;
\item \code{carit}, for cardiac arrhythmias;
\item \code{valv}, for valvular disease;
\item \code{pcd}, for pulmonary circulation disorders;
\item \code{pvd}, for peripheral vascular disorders;
\item \code{hypunc}, for hypertension, uncomplicated;
\item \code{hypc}, for hypertension, complicated;
\item \code{para}, for paralysis;
\item \code{ond}, for other neurological disorders;
\item \code{cpd}, for chronic pulmonary disease;
\item \code{diabunc}, for diabetes, uncomplicated;
\item \code{diabc}, for diabetes, complicated;
\item \code{hypothy}, for hypothyroidism;
\item \code{rf}, for renal failure;
\item \code{ld}, for liver disease;
\item \code{pud}, for peptic ulcer disease, excluding bleeding;
\item \code{aids}, for AIDS/HIV;
\item \code{lymph}, for lymphoma;
\item \code{metacanc}, for metastatic cancer;
\item \code{solidtum}, for solid tumour, without metastasis;
\item \code{rheumd}, for rheumatoid arthritis/collaged vascular disease;
\item \code{coag}, for coagulopathy;
\item \code{obes}, for obesity;
\item \code{wloss}, for weight loss;
\item \code{fed}, for fluid and electrolyte disorders;
\item \code{blane}, for blood loss anaemia;
\item \code{dane}, for deficiency anaemia;
\item \code{alcohol}, for alcohol abuse;
\item \code{drug}, for drug abuse;
\item \code{psycho}, for psychoses;
\item \code{depre}, for depression;
}

Labels are presented to the user when using the RStudio viewer (e.g. via the \code{\link[utils:View]{utils::View()}} function) for convenience.
}
\description{
Maps comorbidity conditions using algorithms from the Charlson and the Elixhauser comorbidity scores.
}
\details{
The ICD-10 and ICD-9-CM coding for the Charlson and Elixhauser scores is based on work by Quan \emph{et al}. (2005).
ICD-10 and ICD-9 codes must be in upper case and with alphanumeric characters only in order to be properly recognised; set \code{tidy.codes = TRUE} to properly tidy the codes automatically.
A message is printed to the R console when non-alphanumeric characters are found.
}
\examples{
set.seed(1)
x <- data.frame(
  id = sample(1:15, size = 200, replace = TRUE),
  code = sample_diag(200),
  stringsAsFactors = FALSE
)

# Charlson score based on ICD-10 diagnostic codes:
comorbidity(x = x, id = "id", code = "code", map = "charlson_icd10_quan", assign0 = FALSE)

# Elixhauser score based on ICD-10 diagnostic codes:
comorbidity(x = x, id = "id", code = "code", map = "elixhauser_icd10_quan", assign0 = FALSE)
}
\references{
Quan H, Sundararajan V, Halfon P, Fong A, Burnand B, Luthi JC, et al. \emph{Coding algorithms for defining comorbidities in ICD-9-CM and ICD-10 administrative data}. Medical Care 2005; 43(11):1130-1139.

Charlson ME, Pompei P, Ales KL, et al. \emph{A new method of classifying prognostic comorbidity in longitudinal studies: development and validation}. Journal of Chronic Diseases 1987; 40:373-383.

Ludvigsson JF, Appelros P, Askling J et al. \emph{Adaptation of the Charlson Comorbidity Index for register-based research in Sweden}. Clinical Epidemiology 2021; 13:21-41.

Sundararajan V, Henderson T, Perry C, Muggivan A, Quan H, Ghali WA. \emph{New ICD-10 version of the Charlson comorbidity index predicted in-hospital mortality}. Journal of Clinical Epidemiology 2004; 57(12):1288-1294.
}
