% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_diag_icd10.R
\name{sample_diag_icd10}
\alias{sample_diag_icd10}
\title{Simulate ICD-10 diagnostic codes}
\usage{
sample_diag_icd10(n = 1, version = "2011")
}
\arguments{
\item{n}{Number of ICD-10 codes to simulate.}

\item{version}{The version of the ICD-10 coding scheme to use. Possible choices are \code{2009} and \code{2011}; defaults to \code{2011}. See \link[comorbidity:icd10_2009]{comorbidity::icd10_2009} and \link[comorbidity:icd10_2011]{comorbidity::icd10_2011} for further information on the different schemes.}
}
\value{
A vector of \code{n} ICD-10 diagnostic codes.
}
\description{
A simple function to simulate ICD-10 diagnostic codes at random.
}
\examples{
# Simulate 10 ICD-10 codes
sample_diag_icd10(10)

# Simulate a tidy dataset with 15 individuals and 200 rows
set.seed(1)
x <- data.frame(
  id = sample(1:15, size = 200, replace = TRUE),
  code = sample_diag_icd10(n = 200),
  stringsAsFactors = FALSE)
head(x)

}
