% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combs_with.R
\name{combs_with}
\alias{combs_with}
\title{Show combinations with given markers.}
\usage{
combs_with(markers, markers_table)
}
\arguments{
\item{markers}{a character vector containing one or more markers of interest.}

\item{markers_table}{a data.frame with ranked combination, reporting: SE, SP, number of markers composing the combination and the score (returned by ranked_combs()).}
}
\value{
a numeric vector containing the numbers corresponding to the combinations containing all the selected markers.
}
\description{
A function to find all the combinations containing all the markers of interest.
}
\examples{
demo_data # combiroc built-in demo data (proteomics data from Zingaretti et al. 2012 - PMC3518104)

combs <- combi(data= demo_data, signalthr=450, combithr=1)  # compute combinations

# To show all the combinations with given markers.

combs_with(markers = c('Marker1', 'Marker2') , markers_table = combs)
}
