\name{tristimulusMunsell}
\alias{tristimulusMunsell}
\title{434 Munsell colors with tristimulus and CMFs for a few illuminants}
\usage{tristimulusMunsell}
\description{\code{tristimulusMunsell} is a table with 434 Munsell colors with 
tristimulus and Color matching functions for illuminants A, C D and S.}
\format{
  This data frame contains the following data:
  \describe{
    \item{Munsell}{ Munsell color notation}
    \item{X.A}{ tristimulus X for illuminant A}
    \item{Y.A}{ tristimulus Y for illuminant A}
    \item{Z.A}{ tristimulus Z for illuminant A}
    \item{x.A}{ CMF x for illuminant A}
    \item{y.A}{ CMF y for illuminant A}
    \item{X.C}{ tristimulus X for illuminant C}
    \item{Y.C}{ tristimulus Y for illuminant C}
    \item{Z.C}{ tristimulus Z for illuminant C}
    \item{x.C}{ CMF x for illuminant C}
    \item{y.C}{ CMF y for illuminant C}
    \item{X.D}{ tristimulus X for illuminant D}
    \item{Y.D}{ tristimulus Y for illuminant D}
    \item{Z.D}{ tristimulus Z for illuminant D}
    \item{x.D}{ CMF x for illuminant D}
    \item{y.D}{ CMF y for illuminant D}
    \item{X.S}{ tristimulus for X illuminant S}
    \item{Y.S}{ tristimulus for Y illuminant S}
    \item{Z.S}{ tristimulus for Z illuminant S}
    \item{x.S}{ CMF x for illuminant S}
    \item{y.S}{ CMF y for illuminant S}
    \item{X}{ Munsell painting number}
  }
}
\source{
K. L. Kelley, K. S. Gibson, and D. Nickerson, 1943
"Tristimulus specification of the Munsell Book of Color from 
spectrophotometric measurements,"
J. Opt. Soc. Am. 33, 355–376
}
\references{
K. L. Kelley, K. S. Gibson, and D. Nickerson, 1943
"Tristimulus specification of the Munsell Book of Color from 
spectrophotometric measurements,"
J. Opt. Soc. Am. 33, 355–376
}
\author{Jose Gama}
\examples{
data(tristimulusMunsell)
tristimulusMunsell
}
\keyword{datasets}

