% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette.R
\name{palette_timeline}
\alias{palette_timeline}
\title{Make an HCL palette for visualizing a linear sequence of distributions}
\usage{
palette_timeline(x, start_hue = -130, clockwise = FALSE)
}
\arguments{
\item{x}{RasterStack or integer describing the number of layers for which
colors need to be generated.}

\item{start_hue}{integer between -360 and 360 representing the starting hue
in the color wheel. For further details, consult the documentation for
\link[colorspace:rainbow_hcl]{colorspace::rainbow_hcl}. Recommended values are -130 ("blue-pink-yellow"
palette) and 50 ("yellow-green-blue" palette).}

\item{clockwise}{logical indicating which direction to move around an HCL
color wheel. When \code{clockwise = FALSE} the ending hue will be \code{start_hue + 180}. When \code{clockwise = TRUE} the ending hue will be \code{start_hue - 180}. The
default value \code{clockwise = FALSE} will yield a "blue-pink-yellow" palette
when \code{start_hue = -130}, while \code{clockwise = TRUE} will yield a
"blue-green-yellow" palette.}
}
\value{
A data frame with three columns:
\itemize{
\item \code{layer_id}: integer identifying the layer containing the maximum
intensity value; mapped to hue.
\item \code{specificity}: the degree to which intensity values are unevenly
distributed across layers; mapped to chroma.
\item \code{color}: the hexadecimal color associated with the given layer and
specificity values.
}
}
\description{
This function generates an HCL palette for visualizing a linear
sequence of distributions (e.g., a series of utilization
distributions describing space use by an individual animal across each of
20 consecutive days or a series of species distributions describing
projected responses to global warming in 0.5 C increments).
}
\examples{
# load fisher data
data(fisher_ud)

# generate hcl color palette
pal_a <- palette_timeline(fisher_ud)
head(pal_a)

# use a clockwise palette
pal_b <- palette_timeline(fisher_ud, clockwise = TRUE)

# try a different starting hue
pal_c <- palette_timeline(fisher_ud, start = 50)

# visualize the palette in HCL space  with colorspace::hclplot
library(colorspace)
hclplot(pal_a[pal_a$specificity == 100, ]$color)
hclplot(pal_b[pal_b$specificity == 100, ]$color)
hclplot(pal_c[pal_c$specificity == 100, ]$color)
}
\seealso{
\link{palette_timecycle} for cyclical sequences of distributions and
\link{palette_set} for unordered sets of distributions.

Other palette: 
\code{\link{palette_set}()},
\code{\link{palette_timecycle}()}
}
\concept{palette}
