% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_populations.R
\name{timeseries}
\alias{timeseries}
\title{Simulate a Time Series of a Temporally Autocorrelated Population}
\usage{
timeseries(start, timesteps, phi, survMean, survSd, fecundMean, fecundSd)
}
\arguments{
\item{start}{The starting population size.}

\item{timesteps}{The number of timesteps you want to simulate. Individuals
are added and killed off every timestep according to the survival and
fertility rates. In ecological applications, timesteps are usually years,
but theoretically they can be any length of time.}

\item{phi}{The temporal autocorrelation. 0 is white noise (uncorrelated),
positive values are red noise (directly correlated) and negative values are
blue noise (inversely correlated).}

\item{survMean}{The mean survival from timestep to timestep. Must be a value
between 0 (all individuals die) and 1 (all individuals live).}

\item{survSd}{The standard deviation of the survival from timestep to
timestep. Must be a value between 0 and 1.}

\item{fecundMean}{The mean fertility. Must be a number from 0 (no one
reproduces) to 1 (everyone reproduces).}

\item{fecundSd}{The standard deviation of the fertility. Must be a number
from 0 to 1.}
}
\value{
A data frame with five variables: timestep, newborns (new individuals
  added this timestep), survivors (individuals alive last year who survived
  this timestep), population (total individuals alive), and growth (the
  increase or decrease in population size from last year).
}
\description{
The backbone of this package, this function simulates a population with
temporally autocorrelated vital rates (survival and fertility). In other
words, this function will show you the dynamics over time of a population
whose survival and fertility is stochastic, but also correlated to the
survival and fertility in the previous year. The assumptions of the
simulation are that the population is asexually reproducing or female-only,
individuals are able to reproduce in their first timestep, survival and
fertility are the same at all ages, in every timestep they either produce 0
or 1 offspring, and that individuals continue to be reproductively capable
until they die.
}
\details{
Be advised that not all combinations of values will work. Certain combinations
of mean and SD for survival and fecundity are very unrealistic for real
populations, and you'll end up with mostly NAs in your output. Use common sense
as a demogropher / population biologist; if you give the timeseries function
a mean fecundity of 0.9 and a SD of 1, you're going to break the simulation
and get NA values.
}
\examples{
series1 <- timeseries(start = 20, timesteps = 10, phi = 0.4, survMean = 0.6,
survSd = 0.52, fecundMean = 0.3, fecundSd = 0.7)
head(series1)
}
