% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_encoding_methods.R
\name{add_white_noise}
\alias{add_white_noise}
\title{Add White Noise to Encoded Predictor}
\usage{
add_white_noise(
  df = NULL,
  response = NULL,
  predictor = NULL,
  white_noise = 0,
  seed = 1
)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{response}{(optional, character string) Name of a numeric response variable in \code{df}. Default: NULL.}

\item{predictor}{(required, string) Name of a target-encoded predictor. Default: NULL}

\item{white_noise}{(optional; numeric vector) Argument of the methods "mean", "rank", and "loo". Maximum white noise to add, expressed as a fraction of the range of the response variable. Range from 0 to 1. Default: \code{0}.}

\item{seed}{(optional; integer vector) Random seed to facilitate reproducibility when \code{white_noise} is not 0. If NULL, the function selects one at random, and the selected seed does not appear in the encoded variable names. Default: 0}
}
\value{
data frame
}
\description{
Internal function to add white noise to a encoded predictor to reduce the risk of overfitting when used in a model along with the response.
}
\seealso{
Other target_encoding_tools: 
\code{\link{encoded_predictor_name}()}
}
\concept{target_encoding_tools}
