% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translation.r
\name{censored_translation}
\alias{censored_translation}
\title{Censored Translation of a DNA string.}
\usage{
censored_translation(dna_str, reading_frame = 1)
}
\arguments{
\item{dna_str}{The DNA string to be translated.}

\item{reading_frame}{Set the reading frame of the sequence. reading_frame = 1 (default)
means the first bp in the string is the start of the first codon, can pass: 1, 2, or 3.
i.e. reading_frame = 2 indicates that the second bp in the string is the start of the first codon.}
}
\description{
Translate a DNA sequence using the censored translation table.
This translates codons for which the amino acids are unambiguous across
mitochondrial genetic codes across the animal kingdom and does not
translate those for which the amino acid varies,
but rather outputs a ? in the string.
}
\examples{
#translate a string of DNA:
censored_translation(example_nt_string)
#manually override the reading frame:
censored_translation(example_nt_string, reading_frame = 2)
}
