% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohorttools.R
\name{boxesLx}
\alias{boxesLx}
\title{Boxes plot summarizing Lexis object}
\usage{
boxesLx(x, layout = "circo", prop.penwidth = FALSE, scale.Y = 1,
  node.attr = "shape=box", edge.attr = "minlen=1", fontsizeN = 14,
  fontsizeL = 8, show.gr = TRUE)
}
\arguments{
\item{x}{Lexis object}

\item{layout}{Graphviz layout "circo", "dot", "twopi" or, "neato".
It determines general layout of graph.}

\item{prop.penwidth}{use line width relative to incidence. If TRUE linewidths of
showing transition rates beween states are relative to log of rate.}

\item{scale.Y}{scale for incidence. Scale factor rates, default is 1.}

\item{node.attr}{general node attributers.
Attributes like shape, color, fillcolor, etc. for nodes.
Consult Graphviz documentation for details
\url{https://www.graphviz.org/doc/info/attrs.html}.}

\item{edge.attr}{general edge (line) attributers.
Attributes like  color, arrowhead, fontcolor  etc. for edges.
Consult Graphviz documentation for details
\url{https://www.graphviz.org/doc/info/attrs.html}}

\item{fontsizeN}{font size for nodes}

\item{fontsizeL}{font size for edges}

\item{show.gr}{should graph be shown. If TRUE,
function DiagrammeR::grViz is used to show graph.}
}
\value{
Character vector containing Graphviz script. This may used
to create graph by  DiagrammeR::grViz function.
}
\description{
Creates boxes graph describing Lexis
}
\examples{
library(DiagrammeR)
library(survival)
library(Epi)
library(mstate)
data(ebmt3)
bmt <- Lexis(exit = list(tft = rfstime/365.25),
             exit.status = factor(rfsstat, labels = c("Tx", "RD")),
                          data = ebmt3)
bmtr <- cutLexis(bmt, cut = bmt$prtime/365.25, precursor.states = "Tx",
                                           new.state = "PR")
summary(bmtr)
boxesLx(bmtr)
boxesLx(bmtr,layout="dot")
boxesLx(bmtr,node.attr='shape=hexagon color=navy style=filled fillcolor=lightblue',
edge.attr = ' color=steelblue arrowhead=vee fontcolor="#8801d7" ',
layout="circo",prop.penwidth=TRUE)
}
\seealso{
\code{\link{grViz}}
}
\author{
Jari Haukka \href{mailto:jari.haukka@helsinki.fi}{jari.haukka@helsinki.fi}
}
