% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-report.R
\name{SheetCoding}
\alias{SheetCoding}
\title{Create a useful informational sheet for coding}
\usage{
SheetCoding(project, format = "html", output_dir = tempdir())
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{format}{A character string, the format of the report you want. 'html' (default), 'pdf'.}

\item{output_dir}{A character string, the output directory of the rendered file (see rmarkdown::render())}
}
\value{
A cute message.
}
\description{
Create a useful informational sheet for coding
}
\details{
Create a document with main information of the Qualitative Date Analysis project (id of documents, of edges, of vertices, units, ...). The 'pdf' format will depend on a LaTeX installation. The reports will be stored in a subfolder of your working directory ('./data-output/sheet_coding.ext').
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

SheetCoding(my.project)
## Need a pdf installation
## SheetCoding(my.project, "pdf")
}
