% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporal_torus_translation.R
\name{confint.cyclic_shift}
\alias{confint.cyclic_shift}
\title{Confidence Intervals from a Cyclic Shift Permutation}
\usage{
\method{confint}{cyclic_shift}(object, parm = "out", level = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{cyclic_shift}}

\item{parm}{which parameter is to be given a confidence interval. At present there is only one option: the mean of the null distribution. Defaults to "out", referring to the null distribution in objects of class \code{cyclic_shift}.}

\item{level}{the confidence level required.}

\item{...}{further arguments to \code{quantile}}
}
\value{
A dataframe with the following columns:
\itemize{
 \item{lowerCI: }{A numeric column with the lowest confidence interval value.}
 \item{upperCI: }{A numeric column with the highest confidence interval value.}
 \item{nullMean: }{A numeric column with the average value of the specified test statistic when calculated on a null community.}
}
}
\description{
Calculates confidence intervals for the S3 object produced by \code{cyclic_shift}
}
\examples{
# Calculate a covariance matrix on a null community
data(knz_001d)
a1_cyclic <- cyclic_shift(subset(knz_001d, subplot == "A_1"),
                   time.var = "year",
                   species.var = "species",
                   abundance.var = "abundance",
                   FUN = cov,
                   bootnumber = 10)

# Return CI on a1_cyclic
confint(a1_cyclic)
}
\references{
Hallett, Lauren M., Joanna S. Hsu, Elsa E. Cleland, Scott L. Collins, Timothy L. Dickson, Emily C. Farrer, Laureano A. Gherardi, et al. "Biotic Mechanisms of Community Stability Shift along a Precipitation Gradient." Ecology 95, no. 6 (2014): 1693-1700.

Harms, Kyle E., Richard Condit, Stephen P. Hubbell, and Robin B. Foster. "Habitat Associations of Trees and Shrubs in a 50-Ha Neotropical Forest Plot." Journal of Ecology 89, no. 6 (2001): 947-59.
}

