% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{print.classified}
\alias{print.classified}
\title{Printing classified data}
\usage{
\method{print}{classified}(x, ...)
}
\arguments{
\item{x}{output from \code{\link[=classify]{classify()}}}

\item{...}{additional arguments passed to printing method for a \code{tibble}.
\code{n} is the number of rows to preview.
Set \code{n = NULL} to disable the \code{tibble}
preview and print the object as is (a matrix).}
}
\description{
Preview first \code{n} rows as tibble
}
\examples{
# Preview all output
classify(c("C80", "I20", "unvalid_code"), "elixhauser")

# Preview only the first row
print(classify(c("C80", "I20", "unvalid_code"), "elixhauser"), n = 1)

# Print object as is (matrix)
print(classify(c("C80", "I20", "unvalid_code"), "elixhauser"), n = NULL)
}
\seealso{
Other classcodes: 
\code{\link{all_classcodes}()},
\code{\link{as.data.frame.classified}()},
\code{\link{classcodes}},
\code{\link{codebook}()},
\code{\link{print.classcodes}()},
\code{\link{set_classcodes}()},
\code{\link{summary.classcodes}()},
\code{\link{visualize.classcodes}()}
}
\concept{classcodes}
