% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda4microbiome_longitudinal_functions.R
\name{explore_lr_longitudinal}
\alias{explore_lr_longitudinal}
\title{explore_lr_longitudinal}
\usage{
explore_lr_longitudinal(
  x,
  y,
  x_time,
  subject_id,
  ini_time,
  end_time,
  showPlots = FALSE,
  decreasing = TRUE,
  covar = NULL,
  shownames = FALSE,
  maxrow = 15,
  maxcol = 15,
  showtitle = TRUE,
  mar = c(0, 0, 1, 0)
)
}
\arguments{
\item{x}{abundance table in long format (several rows per individual)}

\item{y}{outcome (binary)}

\item{x_time}{observation times}

\item{subject_id}{subject id}

\item{ini_time}{initial time to be analyzed}

\item{end_time}{end time to be analyzed}

\item{showPlots}{if TRUE, shows the plot (default = FALSE)}

\item{decreasing}{order of importance (default = TRUE)}

\item{covar}{data frame with covariates (default = NULL)}

\item{shownames}{if TRUE, shows the names of the variables in the rows of the plot (default = FALSE)}

\item{maxrow}{maximum number of rows to display in the plot (default = 15)}

\item{maxcol}{maximum number of columns to display in the plot (default = 15)}

\item{showtitle}{logical, if TRUE, shows the title of the plot (default = TRUE)}

\item{mar}{mar numerical vector of the form c(bottom, left, top, right) which gives the number of lines of margin to be specified on the four sides of the plot (default mar=c(0,0,1,0))}
}
\value{
list with "max log-ratio","names max log-ratio","order of importance","name of most important variables","association log-ratio with y","top log-ratios plot"
}
\description{
Explores the association of summary (integral) of each log-ratio trajectory with the outcome.
Summarizes the importance of each variable (taxa) as the aggregation of
the association measures of those log-ratios involving the variable. The output includes a plot
of the association of the log-ratio with the outcome where the variables (taxa) are ranked by importance
}
\examples{

set.seed(123) # to reproduce the results

data(ecam_filtered, package = "coda4microbiome")   # load the data

x=x_ecam # microbiome abundance
x_time = metadata$day_of_life    # observation times
subject_id = metadata$studyid   # subject id
y= metadata$diet           # diet ("bd"= breast diet, "fd"=formula diet)
ini_time = 0
end_time = 90

ecam_logratios<-explore_lr_longitudinal(x,y,x_time,subject_id,ini_time,end_time)

}
\author{
M. Calle - T. Susin
}
