% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/synthetic_datasets.R
\name{create_syn_data_toy}
\alias{create_syn_data_toy}
\title{An illustrative synthetic datacollection}
\usage{
create_syn_data_toy(N = 100, normalize = T, noisemf = 0.1)
}
\arguments{
\item{N}{Number of observations in data as integer}

\item{normalize}{(optional) Should the data be processed with dl_scale()? A boolean value.}

\item{noisemf}{(optional) Multiplication factor for noise}
}
\value{
A list with elements
\item{data}{Data collection as a list of data.frames}
\item{Z_all}{Signals shared by all datasets in the collection}
\item{Z_sub}{Signals not shared by all datasets}
\item{W_all}{Mixing weights for Z_all}
\item{W_sub}{Mixing weights for Z_sub}
\item{E}{Noise}
\item{var.coef}{Noise multiplication factor used}
}
\description{
Model: D_k = D_shared_by_all + D_shared_by_subset + D_unique,
}
\examples{
\dontrun{
dc <- create_syn_data_toy()
ggplot_dflst(dc$data, ncol = 1)
}
}

