% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_statvalues.R
\encoding{UTF-8}
\name{format_corr}
\alias{format_corr}
\title{Format correlation statistics}
\usage{
format_corr(x, digits, pdigits, pzero, full, italics, type, ...)
}
\arguments{
\item{x}{An \code{htest} object}

\item{digits}{Number of digits after the decimal for means, confidence
intervals, and test statistics}

\item{pdigits}{Number of digits after the decimal for p-values, ranging
between 1-5 (also controls cutoff for small p-values)}

\item{pzero}{Logical value (default = FALSE) for whether to include
leading zero for p-values}

\item{full}{Logical value (default = TRUE) for whether to include means
and confidence intervals or just test statistic and p-value}

\item{italics}{Logical value (default = TRUE) for whether \emph{p} label should be
italicized}

\item{type}{Type of formatting ("md" = markdown, "latex" = LaTeX)}

\item{...}{Additional arguments passed to methods.}
}
\value{
A character string of statistical information formatted in Markdown or LaTeX.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

With \code{format_corr()} you can format correlation statistics generated from
\code{\link[=cor.test]{cor.test()}} output.
This is now an internal function superceded by \code{\link[=format_stats]{format_stats()}}, which we
recommend using instead.
}
\examples{
# format_stats(cor.test(mtcars$mpg, mtcars$cyl))
}
\seealso{
Other functions for printing statistical objects: 
\code{\link{format_bf}()},
\code{\link{format_stats}()},
\code{\link{format_stats.BFBayesFactor}()},
\code{\link{format_stats.easycorrelation}()},
\code{\link{format_stats.htest}()},
\code{\link{format_ttest}()}
}
\concept{functions for printing statistical objects}
