% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalition-probability.R
\name{get_superior}
\alias{get_superior}
\title{Extract superior coalitions from coalition string or vector}
\usage{
get_superior(string, pattern = "_", collapse = "_")
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described
in \link[stringi:stringi-search-regex]{stringi::stringi-search-regex}. Control options with
\code{\link[=regex]{regex()}}.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[=boundary]{boundary()}}. An empty pattern, "", is equivalent to
\code{boundary("character")}.}

\item{collapse}{string that will be used to concatenate multiple elements
obtained by splitting \code{string} to one string.}
}
\description{
Extract superior coalitions from coalition string or vector
}
\seealso{
stringr str_split
}
\keyword{internal}
