% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooling.R
\name{get_pooled}
\alias{get_pooled}
\title{Extract effective sample size for pooled sample}
\usage{
get_pooled(surveys, last_date = Sys.Date(), pollsters = c("allensbach",
  "emnid", "forsa", "fgw", "gms", "infratest", "dimap", "infratestdimap",
  "insa"), period = 14, period_extended = NA, corr = 0.5,
  weights = NULL)
}
\arguments{
\item{surveys}{A \code{tibble} containing survey results for multiple
pollsters as returned by \code{\link[coalitions]{get_surveys}}.}

\item{last_date}{Only surveys in the time-window from \code{last_date} to
\code{last_date} - period will be considered for each pollster. Defaults
to current date.}

\item{pollsters}{Character vector of pollsters that should be considered
for pooling.}

\item{period}{See \code{last_date} argument.}

\item{period_extended}{Optional. If specified, all surveys in the time-window
from \code{last_date} - period_extended to \code{last_date} - period will
also be considered for each pollster, but only after down-weighting them by
halving their true sample size.}

\item{corr}{Assumed correlation between surveys (of different pollsters).
Defaults to 0.5.}

\item{weights}{Additional weights for individual surveys.}
}
\description{
Given a specified time window (defaults to current day - 14 days).
calculate the effective sample size of the pooled sample over multiple
pollsters.
}
\keyword{internal}
