% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{coal_model}
\alias{coal_model}
\title{Creates a coalescent model}
\usage{
coal_model(sample_size, loci_number = 0, loci_length = 1000, ploidy = 1)
}
\arguments{
\item{sample_size}{Defines the number of populations and the number of
individual sampled from each population. Given as an integer vector where
each entry gives the number of individuals sampled from the corresponding
population.}

\item{loci_number}{You can optionally add a number of loci with equal length
to the model. This gives to number of loci to add.}

\item{loci_length}{This gives the length of the loci to add.}

\item{ploidy}{The number of chromosomes that will be simulated per
individual.}
}
\value{
The coalescent model
}
\description{
This creates a basic coalescent model to which more features, loci,
parameters and summary statistics can be added. Data under the model
can be simulated using the \code{simulate} function.
}
\examples{
model <- coal_model(5, 10, 100) + feat_mutation(1) + sumstat_sfs()
simulate(model)

model <- coal_model(c(2, 2), 1, 10) +
  feat_recombination(1) +
  feat_migration(0.5, symmetric = TRUE) +
  sumstat_trees()
simulate(model)
}

