% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmc.R
\name{LCMC}
\alias{LCMC}
\title{The local continuity meta-criterion}
\usage{
LCMC(Q, K = 1:nrow(Q))
}
\arguments{
\item{Q}{a co-ranking matrix}

\item{K}{vector of integers describing neighborhood size}
}
\value{
A number, the local continuity meta-criterion
}
\description{
Calculate the local continuity meta-criterion from a co-ranking matrix.
}
\details{
The local continuity meta-criterion (Chen and Buja, 2006) is defined as
\deqn{ LCMC = \frac{K}{1-N} +
              \frac{1}{NK} \sum_{(k,l)\in U  L_K} q_{kl} }
Higher values mean a better performance of the dimensionality reduction.
}
\author{
Guido Kraemer
}
